% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/islasso.R
\name{aic.islasso}
\alias{aic.islasso}
\title{Optimization for Lambda Selection}
\usage{
aic.islasso(
  object,
  method = c("AIC", "BIC", "AICc", "GCV", "GIC"),
  interval,
  g = 0,
  y,
  X,
  intercept = FALSE,
  family = gaussian(),
  alpha = 1,
  offset,
  weights,
  unpenalized,
  control = is.control(),
  trace = TRUE
)
}
\arguments{
\item{object}{Fitted model of class \code{"islasso"}.}

\item{method}{Criterion to minimize. Options are \code{"AIC"}, \code{"BIC"}, \code{"AICc"}, \code{"GCV"}, \code{"GIC"}.}

\item{interval}{Numeric vector (length 2) giving lower and upper bounds for \code{lambda} optimization. Optional if \code{object} includes prior cross-validation.}

\item{g}{Numeric in \code{[0,1]}. Governs BIC generalization: \code{g = 0} is classic BIC, \code{g = 0.5} is extended BIC.}

\item{y}{Response vector. Required only if \code{object} is missing.}

\item{X}{Design matrix. Required only if \code{object} is missing.}

\item{intercept}{Logical. Whether to include intercept in \code{X}. Used if \code{object} is missing.}

\item{family}{Error distribution. Accepted: \code{gaussian}, \code{binomial}, \code{poisson}. Uses canonical link.}

\item{alpha}{Elastic-net mixing parameter, \code{0 <= alpha <= 1}. Lasso: \code{alpha = 1}; Ridge: \code{alpha = 0}.}

\item{offset}{Optional numeric vector. Adds known linear predictor component.}

\item{weights}{Optional weights for observations. Defaults to 1.}

\item{unpenalized}{Logical vector indicating variables to exclude from penalization.}

\item{control}{List of control parameters. See \code{\link{is.control}}.}

\item{trace}{Logical. If \code{TRUE}, prints progress of optimization. Default is \code{TRUE}.}
}
\value{
Optimal \code{lambda} value as numeric.
}
\description{
Minimizes information criteria to select the optimal tuning parameter \code{lambda} for \code{\link{islasso}} models.
Supports AIC, BIC, AICc, GCV, and GIC.
}
\details{
Instead of using cross-validation, this function selects the best \code{lambda} by minimizing criteria like AIC or BIC.
Degrees of freedom are computed as the trace of the hat matrix (not necessarily an integer).
}
\examples{
set.seed(1)
n <- 100; p <- 100
beta <- c(rep(2, 20), rep(0, p - 20))
sim1 <- simulXy(n = n, p = p, beta = beta, seed = 1, family = gaussian())
o <- islasso(y ~ ., data = sim1$data, family = gaussian())

\dontrun{
# Use the evaluation interval of the fit
lambda_aic <- aic.islasso(o, method = "AIC")

# Overwrites the evaluation interval for lambda
lambda_bic <- aic.islasso(o, interval = c(0.1, 30), method = "BIC")

# Overwrites the evaluation interval for lambda using eBIC criterion
lambda_ebic <- aic.islasso(o, interval = c(0.1, 30), method = "BIC", g = 0.5)
}

}
\seealso{
\code{\link{islasso}}, \code{\link{islasso.path}}, \code{\link{is.control}}, \code{\link{simulXy}}
}
\author{
Gianluca Sottile \email{gianluca.sottile@unipa.it}
}
