% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivx.R
\name{ivx_fit}
\alias{ivx_fit}
\alias{ivx_wfit}
\title{Fitter Functions for IVX Models}
\usage{
ivx_fit(y, x, horizon = 1, offset = NULL, ...)

ivx_wfit(y, x, w, horizon = 1, offset = NULL, ...)
}
\arguments{
\item{y}{vector of observations of length \code{n}, or a matrix with
    \code{n} rows.}

\item{x}{design matrix of dimension \code{n * p}.}

\item{horizon}{is the horizon (default horizon = 1 corresponds to a
short-horizon regression).}

\item{offset}{(numeric of length \code{n}).  This can be used to
    specify an \emph{a priori} known component to be included in the
    linear predictor during fitting.}

\item{...}{currently disregarded.}

\item{w}{vector of weights (length \code{n}) to be used in the fitting
    process for the \code{wfit} functions.  Weighted least squares is
    used with weights \code{w}, i.e., \code{sum(w * e^2)} is minimized.}
}
\description{
Basic function called by \code{ivx} to fit predictive models.
These should only be used directly by experienced users.
}
\examples{
ivx_fit(monthly$Ret, as.matrix(monthly$LTY))
}
