% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{allocateCultivarGenes}
\alias{allocateCultivarGenes}
\title{Allocate genes to a cultivar}
\usage{
allocateCultivarGenes(
  params,
  cultivarName,
  listGenesNames = c(""),
  force.clean = FALSE
)
}
\arguments{
\item{params}{a LandsepiParams object.}

\item{cultivarName}{the name of the cultivar to be allocated.}

\item{listGenesNames}{the names of the genes the cultivar carries}

\item{force.clean}{force to clean previous allocated genes to all cultivars}
}
\value{
a LandsepiParams object
}
\description{
Updates a LandsepiParams object with, for a given cultivar, the list of genes
it carries
}
\examples{
\dontrun{
simul_params <- createSimulParams()
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene2 <- loadGene(name = "MG 2", type = "majorGene")
genes <- data.frame(rbind(gene1, gene2), stringsAsFactors = FALSE)
simul_params <- setGenes(simul_params, genes)
cultivar1 <- loadCultivar(name = "Susceptible", type = "wheat")
cultivar2 <- loadCultivar(name = "Resistant", type = "wheat")
cultivars <- data.frame(rbind(cultivar1, cultivar2), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
simul_params <- allocateCultivarGenes(simul_params, "Resistant", c("MG 1", "MG 2"))
simul_params@CultivarsGenes
}
}
\seealso{
\link{setGenes}, \link{setCultivars}
}
