% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptCompare.R
\name{reptCompare}
\alias{reptCompare}
\title{Compare a Species nomenclature with Reptile Database Data}
\usage{
reptCompare(x = NULL, y = NULL, filter = NULL)
}
\arguments{
\item{x}{A character vector or a data frame containing a column named \code{species} with species names to be compared.}

\item{y}{Optional. A character vector or a data frame containing a column named \code{species} to compare against. Defaults to the internal object \code{allReptiles}.}

\item{filter}{Optional. A character string. If \code{"review"}, returns only unmatched species.
If \code{"matched"}, returns only matched species. If \code{NULL} (default), returns a data frame of both.}
}
\value{
A character vector (if \code{filter} is \code{"review"} or \code{"matched"}), or a data frame with columns:
\describe{
\item{species}{Species names from \code{x}}
\item{status}{Comparison result: \code{"review"} or \code{"matched"}}
}
}
\description{
This function compares a list of species (\code{x}) with another list (\code{y}), typically from the Reptile Database (RDB).
If \code{y} is not provided, it defaults to using the internal object \code{allReptiles}.
The function returns species that are either unmatched ("review") or matched with the RDB list, or both.
}
\examples{
my_species <- data.frame(species = c("Boa constrictor", "Pantherophis guttatus", "Fake species"))
reptCompare(my_species)
reptCompare(my_species, filter = "review")
reptCompare(my_species, filter = "matched")

}
