% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{matmult_block_diagonal}
\alias{matmult_block_diagonal}
\title{Multiply Block Diagonal Matrices in Parallel}
\usage{
matmult_block_diagonal(
  A,
  B,
  K,
  parallel,
  cl,
  chunk_size,
  num_chunks,
  rem_chunks
)
}
\arguments{
\item{A}{List of matrices forming first block diagonal matrix}

\item{B}{List of matrices forming second block diagonal matrix}

\item{K}{Number of blocks minus 1 (\eqn{K})}

\item{parallel}{Logical; whether to use parallel processing}

\item{cl}{Cluster object for parallel processing}

\item{chunk_size}{Number of blocks per chunk for parallel processing}

\item{num_chunks}{Number of chunks for parallel processing}

\item{rem_chunks}{Remaining blocks after chunking}
}
\value{
List containing products of corresponding blocks
}
\description{
Multiplies two lists of matrices that form block diagonal structures, with optional
parallel processing.
}
\details{
When \code{parallel=TRUE}, splits computation into chunks processed in parallel.
Handles remainder chunks separately. Uses \code{matmult_block_diagonal_cpp()} for
actual multiplication.

The function expects A and B to contain corresponding blocks that can be
matrix multiplied.
}
\examples{
A <- list(matrix(1:4,2,2), matrix(5:8,2,2))
B <- list(matrix(1:4,2,2), matrix(5:8,2,2))
matmult_block_diagonal(A, B, K=1, parallel=FALSE, cl=NULL,
                       chunk_size=1, num_chunks=1, rem_chunks=0)

}
\keyword{internal}
