% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_irps.R
\docType{data}
\name{irps_911}
\alias{irps_911}
\title{One-mode multiplex network of relationships between 9/11 hijackers (Krebs 2002)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> -- # 911 Terrorist network -----------------------------------------------------
#> # A labelled, complex, multiplex, undirected network of 60 terrorists and 153
#> association ties and 153 trust ties
#> 
#> -- Nodes
#> # A tibble: 60 x 3
#>   name              hijacker target      
#>   <chr>             <lgl>    <chr>       
#> 1 Majed Moqed       TRUE     Pentagon    
#> 2 Khalid Al Mihdhar TRUE     Pentagon    
#> 3 Hani Hanjour      TRUE     Pentagon    
#> 4 Nawaf Alhazmi     TRUE     Pentagon    
#> 5 Salem Alhazmi     TRUE     Pentagon    
#> 6 Ahmed Alnami      TRUE     Pennsylvania
#> # i 54 more rows
#> 
#> -- Ties
#> # A tibble: 153 x 3
#>    from    to type       
#>   <int> <int> <chr>      
#> 1     1     3 association
#> 2     1     3 trust      
#> 3     2     3 association
#> 4     2     3 trust      
#> 5     2     4 association
#> 6     2     4 trust      
#> # i 147 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(irps_911)
}
\description{
This network records two different types of relationships between and
surrounding the hijackers of four planes in the United States
on September 11, 2001, culminating in those planes crashing into four
locations: New York's World Trade Center (North and South buildings),
as well as the Pentagon and a location in Somerset County, Pennsylvania.

The hijackers were members of al-Qaeda.
Valdis Krebs collected further information from newspapers on the
broader network of associates of these hijackers,
reflecting on the challenges of collecting this information even
after the fact.

The data includes two types of ties:
"trust"ed prior contacts among the hijackers,
and "association" ties among the hijackers but also their broader associates.
All associates are named, along with a logical vector about whether they
were a hijacker or not, and if so which their (eventual) target was.
}
\references{
Krebs, Valdis. 2002.
"Mapping networks of terrorist cells".
\emph{Connections} 24(3): 43-52.
}
\keyword{datasets}
