% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_read.R
\name{make_cran}
\alias{make_cran}
\alias{read_cran}
\alias{read_pkg}
\title{Making networks of inter- and intra-package dependencies}
\source{
https://www.r-bloggers.com/2016/01/r-graph-objects-igraph-vs-network/

https://github.com/STATWORX/helfRlein/blob/master/R/get_network.R
}
\usage{
read_cran(pkg = "all")

read_pkg(dir = getwd())
}
\arguments{
\item{pkg}{The name}

\item{dir}{Character string or vector of character strings
with the directory or directories to search for R scripts.
If \code{NULL} (the default), the current working directory is used.}
}
\value{
A \code{tidygraph} object representing the network of package dependencies
or function dependencies in a package.
}
\description{
These functions read information from CRAN or within an R package's
working directory to create a networks of a package's dependencies:
\itemize{
\item \code{read_cran()} creates a network of a package's dependencies on other
packages available on CRAN.
It looks for the \code{Depends}, \code{Imports} and \code{Suggests} fields
in the package's DESCRIPTION file
and creates a network where nodes are packages
and ties are dependencies.
\item \code{read_pkg()} creates a network of function dependencies
from R scripts in a directory.
It looks for function definitions and function calls
within the scripts and creates a network
where nodes are functions and edges are function calls.
It can also include function calls
to functions not defined within the scripts.
}
}
\details{
Note that these functions are not as actively maintained as others
in the package, so please let us know if any are not currently working
for you or if there are missing import routines
by \href{https://github.com/stocnet/manynet/issues}{raising an issue on Github}.
}
\examples{
# mnet <- read_cran()
# mnet <- to_ego(mnet, "manynet", max_dist = 2)
# mnet <- read_pkg()
}
\seealso{
\link{as}

Other makes: 
\code{\link{make_create}},
\code{\link{make_ego}},
\code{\link{make_explicit}},
\code{\link{make_learning}},
\code{\link{make_motifs}},
\code{\link{make_play}},
\code{\link{make_random}},
\code{\link{make_read}},
\code{\link{make_stochastic}},
\code{\link{make_write}}
}
\author{
Jakob Gepp
}
\concept{makes}
