% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anderson.R
\name{andersondarling}
\alias{andersondarling}
\alias{row_andersondarling}
\alias{col_andersondarling}
\title{Anderson-Darling test}
\usage{
row_andersondarling(x)

col_andersondarling(x)
}
\arguments{
\item{x}{numeric matrix.}
}
\value{
a data.frame where each row contains the results of Anderson-Darling
test performed on the corresponding row/column of x.\cr\cr
Each row contains the following information (in order):\cr
1. obs - number of observations\cr
2. statistic - test statistic\cr
3. pvalue - p-value
}
\description{
Performs Anderson-Darling goodness of fit test for normality.
}
\details{
\code{row_andersondarling(x)} - Anderson-Darling test on rows.
\code{col_andersondarling(x)} - Anderson-Darling test on columns.

Results should be the same as running \code{nortest::ad.test(x)}
on every row (or column) of \code{x}
}
\examples{
col_andersondarling(iris[,1:4])
row_andersondarling(t(iris[,1:4]))

}
\seealso{
\code{shapiro.test()}
}
\author{
Karolis Koncevičius
}
