% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohesionclass.R
\name{cohesionclass}
\alias{cohesionclass}
\title{Calculate the cohesion of samples for each network}
\description{
The cohesion is a method for quantifying the connectivity of microbial communities <doi:10.1038/ismej.2017.91>.
It is defined:
   \deqn{C_{j}^{pos} = \sum_{i=1}^{n} a_{i} \cdot \bar{r_{i}}_{|r>0}}
   \deqn{C_{j}^{neg} = \sum_{i=1}^{n} a_{i} \cdot \bar{r_{i}}_{|r<0}}
 where \eqn{C_{j}^{pos}} is the positive cohesion, and \eqn{C_{j}^{neg}} is the negative cohesion.
 \eqn{a_{i}} is the relative abundance of species i in sample j.
 \eqn{\bar{r_{i}}_{|r>0}} denotes the mean weight (correlation coefficient, interaction strength) of all the edges (related with species i) with positive association.
}
\examples{

## ------------------------------------------------
## Method `cohesionclass$new`
## ------------------------------------------------

t1 <- cohesionclass$new(soil_amp_network)


## ------------------------------------------------
## Method `cohesionclass$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(method = "wilcox")
}

## ------------------------------------------------
## Method `cohesionclass$plot`
## ------------------------------------------------

\donttest{
t1$plot(boxplot_add = "none", add_sig = TRUE)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-cohesionclass-new}{\code{cohesionclass$new()}}
\item \href{#method-cohesionclass-cal_diff}{\code{cohesionclass$cal_diff()}}
\item \href{#method-cohesionclass-plot}{\code{cohesionclass$plot()}}
\item \href{#method-cohesionclass-clone}{\code{cohesionclass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cohesionclass-new"></a>}}
\if{latex}{\out{\hypertarget{method-cohesionclass-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cohesionclass$new(network_list)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{network_list}}{a list with multiple networks; all the networks should be \code{trans_network} object 
created from \code{trans_network} class of microeco package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_list}, stored in the object.
 It includes two tables: res_feature and res_sample. In res_feature, the r_pos and r_neg columns mean the \eqn{\bar{r_{i}}_{|r>0}} and \eqn{\bar{r_{i}}_{|r<0}}.
 In res_sample, the c_pos and c_neg columns denote \eqn{C_{j}^{pos}} and \eqn{C_{j}^{neg}}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{t1 <- cohesionclass$new(soil_amp_network)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cohesionclass-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-cohesionclass-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Differential test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cohesionclass$cal_diff(
  measure = "c_pos",
  method = c("anova", "KW", "KW_dunn", "wilcox", "t.test")[1],
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{default "c_pos"; "c_pos" or "c_neg" in the \code{res_list$sample}; "r_pos" or "r_neg" in the \code{res_list$feature}.}

\item{\code{method}}{default "anova"; see the following available options:
\describe{
  \item{\strong{'anova'}}{Duncan's multiple range test for anova}
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons, see \code{dunnTest} function in \code{FSA} package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
}}

\item{\code{...}}{parameters passed to \code{cal_diff} function of \code{trans_alpha} class of \code{microeco} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_diff} in object. See the Return of \code{cal_diff} function in \code{trans_alpha} class of \code{microeco} package.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(method = "wilcox")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cohesionclass-plot"></a>}}
\if{latex}{\out{\hypertarget{method-cohesionclass-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cohesionclass$plot(measure = "c_pos", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{default "c_pos"; "c_pos" or "c_neg" in the \code{res_list$sample}; "r_pos" or "r_neg" in the \code{res_list$feature}.}

\item{\code{...}}{parameters pass to \code{plot_alpha} function of \code{trans_alpha} class of \code{microeco} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggplot}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot(boxplot_add = "none", add_sig = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cohesionclass-clone"></a>}}
\if{latex}{\out{\hypertarget{method-cohesionclass-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cohesionclass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
