% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gpd.ll}
\alias{gpd.ll}
\alias{gpd.ll.optim}
\title{Log likelihood for the generalized Pareto distribution}
\usage{
gpd.ll(par, dat, tol = 1e-05)

gpd.ll.optim(par, dat, tol = 1e-05)
}
\arguments{
\item{par}{vector of \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{tol}{numerical tolerance for the exponential model}
}
\description{
Function returning the density of an \code{n} sample from the GP distribution.
\code{gpd.ll.optim} returns the negative log likelihood parametrized in terms of \code{log(scale)} and shape
in order to perform unconstrained optimization. The function is coded in such a way that the log likelihood is infinite when \eqn{\xi < -1}.
}
\seealso{
\code{\link{gpd}}
}
\keyword{internal}
