% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{rlarg.infomat}
\alias{rlarg.infomat}
\title{Information matrix for the r-largest observations.}
\usage{
rlarg.infomat(
  par,
  dat,
  method = c("obs", "exp"),
  nobs = nrow(dat),
  r = ncol(dat)
)
}
\arguments{
\item{par}{vector of \code{loc}, \code{scale} and \code{shape}}

\item{dat}{an \code{n} by \code{r} sample matrix, ordered from largest to smallest in each row}

\item{method}{string indicating whether to use the expected  (\code{'exp'}) or the observed (\code{'obs'} - the default) information matrix.}

\item{nobs}{number of observations for the expected information matrix. Default to \code{nrow(dat)} if \code{dat} is provided.}

\item{r}{number of order statistics kept. Default to \code{ncol(dat)}}
}
\description{
The function returns the expected or observed information matrix.
}
\seealso{
\code{\link{rlarg}}
}
\keyword{internal}
