% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tibble.R
\name{check_tibble}
\alias{check_tibble}
\title{Check the output of a tidying method}
\usage{
check_tibble(output, method, columns = colnames(output), strict = TRUE)
}
\arguments{
\item{output}{Object returned from \code{\link[broom:reexports]{broom::tidy()}}, \code{\link[broom:reexports]{broom::augment()}} or \code{\link[broom:reexports]{broom::glance()}}.}

\item{method}{One of \code{"tidy"}, \code{"augment"} or \code{"glance"}. Determines
which set of column name checks are applied.}

\item{columns}{The names of the columns in the output data frame. Defaults
to the column names of \code{output}. Useful when checking \code{\link[broom:reexports]{broom::augment()}} when you only
want to check the new columns in the data frame, as opposed to all
columns.}

\item{strict}{Logical indicating whether the strict version of tests should be used. Defaults
to \code{TRUE}.}
}
\value{
An invisible \code{NULL}. This function should be called for side effects, not return values.
}
\description{
Call this function to perform tests. If a tests fails, an informative error
will be thrown. Otherwise silent.

Tests when \code{strict = FALSE}:
\itemize{
\item \code{output} is a tibble.
}

Additional tests when \code{strict = TRUE}:
\itemize{
\item \code{columns} are listed in the \link{column_glossary}.
}
}
\details{
Do not call directly. Helper function used by \code{\link[=check_tidy_output]{check_tidy_output()}},
\code{\link[=check_glance_outputs]{check_glance_outputs()}} and \code{\link[=check_augment_function]{check_augment_function()}}.
}
