% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.NeuralGAM.R
\name{predict.neuralGAM}
\alias{predict.neuralGAM}
\title{Produces predictions from a fitted \code{neuralGAM} object}
\usage{
\method{predict}{neuralGAM}(
  object,
  newdata = NULL,
  type = c("link", "response", "terms"),
  terms = NULL,
  se.fit = FALSE,
  interval = c("none", "confidence"),
  level = 0.95,
  forward_passes = 150,
  verbose = 1,
  ...
)
}
\arguments{
\item{object}{A fitted \code{neuralGAM} object.}

\item{newdata}{Optional \code{data.frame}/list of covariates at which to predict.
If omitted, the training data cached in the object are used.}

\item{type}{One of \code{c("link","response","terms")}. Default \code{"link"}.}

\item{terms}{If \code{type = "terms"}, character vector of term names to include.
If \code{NULL}, all terms are returned. Intercept is not included (as in \pkg{mgcv}).}

\item{se.fit}{Logical; if \code{TRUE}, return SEs of the fitted mean (epistemic). Default \code{FALSE}.
For \code{type="terms"}, returns a matrix of per-term SEs when available.}

\item{interval}{One of \code{c("none","confidence")} (default \code{"none"}). For \code{type="terms"},
setting \code{interval="confidence"} returns per-term CI matrices.}

\item{level}{Coverage level for confidence intervals (e.g., \code{0.95}). Default \code{0.95}.}

\item{forward_passes}{Integer; number of MC-dropout forward passes when computing
epistemic uncertainty.}

\item{verbose}{Integer (0/1). Default \code{1}.}

\item{\ldots}{Other options (passed on to internal predictors).}
}
\value{
\itemize{
\item \code{type="terms"}:
\itemize{
\item \code{interval="none"}: matrix of per-term contributions; if \code{se.fit=TRUE}, a list with \code{$fit}, \code{$se.fit}.
\item \code{interval="confidence"}: a list with matrices \code{$fit}, \code{$se.fit}, \code{$lwr}, \code{$upr}.
}
\item \code{type="link"} or \code{type="response"}:
\itemize{
\item \code{interval="none"}: vector (or list with \code{$fit}, \code{$se.fit} if \code{se.fit=TRUE}).
\item \code{interval="confidence"}: data.frame with \code{fit}, \code{lwr}, \code{upr}.
}
}
}
\description{
Generate predictions from a fitted \code{neuralGAM} model. Supported types:
\itemize{
\item \code{type = "link"} (default): linear predictor on the link scale.
\item \code{type = "response"}: predictions on the response scale.
\item \code{type = "terms"}: per-term contributions to the linear predictor (no intercept).
}

\strong{Uncertainty estimation via MC Dropout (epistemic only)}
\itemize{
\item If \code{se.fit = TRUE}, standard errors (SE) of the \emph{fitted mean} are returned
(mgcv-style via Monte Carlo Dropout).
\item For \code{type = "response"}, SEs are mapped to the response scale by the delta method:
\eqn{se_\mu = |d\mu/d\eta| \cdot se_\eta}.
\item \code{interval = "confidence"} returns CI bands derived from SEs; prediction intervals are not supported.
\item For \code{type = "terms"}, \code{interval="confidence"} returns per-term CI matrices (and \code{se.fit} when requested).
}

\strong{Details}

\itemize{
\item Epistemic SEs (CIs) are obtained via Monte Carlo Dropout. When \code{type != "terms"}
and SEs/CIs are requested in the presence of smooth terms, uncertainty is aggregated
\emph{jointly} to capture cross-term covariance in a single MC pass set. Otherwise,
per-term variances are used (parametric variances are obtained from \code{stats::predict(..., se.fit=TRUE)}).
\item For \code{type="terms"}, epistemic SEs and CI matrices are returned when requested.
\item PIs are not defined on the link scale and are not supported.
}
}
\examples{
\dontrun{

library(neuralGAM)
dat <- sim_neuralGAM_data()
train <- dat$train
test  <- dat$test

ngam0 <- neuralGAM(
  y ~ s(x1) + x2 + s(x3),
  data = train, family = "gaussian",
  num_units = 128, uncertainty_method = "epistemic"
)
link_ci  <- predict(ngam0, type = "link", interval = "confidence",
                    level = 0.95, forward_passes = 10)
resp_ci  <- predict(ngam0, type = "response", interval = "confidence",
                    level = 0.95, forward_passes = 10)
trm_se   <- predict(ngam0, type = "terms",
                    se.fit = TRUE, forward_passes = 10)
}
}
\author{
Ines Ortega-Fernandez, Marta Sestelo
}
