% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/common.R
\name{split_scale}
\alias{split_scale}
\alias{split_scale,matrix,factor,logical,logical-method}
\alias{split_scale,matrix,factor,missing,missing-method}
\alias{split_scale,DenseNeuroVec,factor,missing,missing-method}
\alias{split_scale,DenseNeuroVec,factor,logical,missing-method}
\alias{split_scale,DenseNeuroVec,factor,logical,logical-method}
\title{Center and/or Scale Row-subsets of a Matrix or Matrix-like Object}
\usage{
split_scale(x, f, center, scale)

\S4method{split_scale}{matrix,factor,logical,logical}(x, f, center = TRUE, scale = TRUE)

\S4method{split_scale}{matrix,factor,missing,missing}(x, f)

\S4method{split_scale}{DenseNeuroVec,factor,missing,missing}(x, f)

\S4method{split_scale}{DenseNeuroVec,factor,logical,missing}(x, f, center)

\S4method{split_scale}{DenseNeuroVec,factor,logical,logical}(x, f, center, scale)
}
\arguments{
\item{x}{A numeric matrix or matrix-like object.}

\item{f}{The splitting object, typically a factor or a set of integer indices. Must be equal to the number of rows in the matrix.}

\item{center}{Should values within each submatrix be centered? If TRUE, the mean is removed from each column of the submatrix.}

\item{scale}{Should values be scaled? If TRUE, the vector is divided by the standard deviation for each column of the submatrix.}
}
\value{
An object of the same class as \code{x}, with row-subsets centered and/or scaled according to \code{f}.
}
\description{
This function centers and/or scales the row-subsets of a numeric matrix or matrix-like object.
}
\examples{

M <- matrix(rnorm(1000), 10, 100)
fac <- factor(rep(1:2, each=5))
Ms <- split_scale(M, fac)

## Correctly centered
all(abs(apply(Ms[fac == 1,], 2, mean)) < .000001)
all(abs(apply(Ms[fac == 2,], 2, mean)) < .000001)

## Correctly scaled
all.equal(apply(Ms[fac == 1,], 2, sd), rep(1, ncol(Ms)))
all.equal(apply(Ms[fac == 2,], 2, sd), rep(1, ncol(Ms)))
}
