% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Clean.R
\name{flag_is_home}
\alias{flag_is_home}
\title{Flag if the event belongs to the home team or not for all the events (plays)
in a play-by-play}
\usage{
flag_is_home(play_by_play)
}
\arguments{
\item{play_by_play}{data.frame of play-by-play(s); see \code{\link[=gc_play_by_play]{gc_play_by_play()}}
and/or \code{\link[=wsc_play_by_play]{wsc_play_by_play()}} for reference; must be untouched by
non-nhlscraper functions}
}
\value{
data.frame with one row per event (play) and added \code{isHome} column
}
\description{
\code{flag_is_home()} flags if the event belongs to the home team or not for
all the events (plays) in a play-by-play.
}
\examples{
# May take >5s, so skip.
\donttest{
  test                 <- gc_play_by_play()
  test_is_home_flagged <- flag_is_home(test)
}
}
