% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_netlogo.R
\name{download_netlogo}
\alias{download_netlogo}
\title{Download NetLogo}
\usage{
download_netlogo(to, version, os = NA, extract = FALSE)
}
\arguments{
\item{to}{Path to folder where the downloaded file is saved.}

\item{version}{Character string naming which NetLogo Version to download (see Details)}

\item{os}{operation system ("win", "mac", "unix") decides which version of netlogo (msi, dmg, tgz) is downloaded.
If set to NA (default) os will be detected automatically (\code{util_get_os()})}

\item{extract}{TRUE/FALSE, if TRUE downloaded archive is extracted to subfolder of \code{to} (only unix)}
}
\description{
Auxiliary function to download NetLogo
}
\details{
Retrieve supported Versions for Download and Usage (parameter \code{version}):
supported_netlogo_versions()
}
\examples{
\dontrun{
dlpath <- tempdir()  # adjust path to your needs
try(download_netlogo(dlpath, "6.0.3"))
}

}
