% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docx_add.R
\name{body_import_docx}
\alias{body_import_docx}
\title{Import an external docx in a 'Word' document}
\usage{
body_import_docx(
  x,
  src,
  par_style_mapping = list(),
  run_style_mapping = list(),
  tbl_style_mapping = list(),
  prepend_chunks_on_styles = list()
)
}
\arguments{
\item{x}{an rdocx object}

\item{src}{path to docx file to import}

\item{par_style_mapping, run_style_mapping, tbl_style_mapping}{Named lists describing how to remap styles from the source document (\code{src})
to styles available in the target document \code{x}. For each list entry, the name
of the element is the target style (in \code{x}), and the value is a character
vector of style names from the source document that should be replaced by
this target style.
\itemize{
\item \code{par_style_mapping}: applies to paragraph styles.
\item \code{run_style_mapping}: applies to character (run) styles.
\item \code{tbl_style_mapping}: applies to table styles.
}

Examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{par_style_mapping = list(
  "Normal"    = c("List Paragraph", "Body Text"),
  "heading 1" = "Heading 1"
)
run_style_mapping = list(
  "Emphasis"  = c("Emphasis", "Italic")
)
tbl_style_mapping = list(
  "Normal Table" = c("Light Shading")
)
}\if{html}{\out{</div>}}

Use \code{\link[=styles_info]{styles_info()}} to inspect available styles and verify their names.}

\item{prepend_chunks_on_styles}{A named list of run chunks to prepend
to runs with specific styles. The names of the list are paragraph style names
and the values run chunks to prepend. The first motivation for this argument
is to allow prepending of runs in paragraphs with a defined style, for example
to add a \code{\link[=run_autonum]{run_autonum()}} with all image captions.}
}
\description{
Import body content and footnotes of a Word document into an rdocx object.

The function is similar to \code{\link[=body_add_docx]{body_add_docx()}} but instead of adding
the content as an external object, the document is read and all its
content is appended to the target document.
}
\details{
The following operations are performed when importing a document:
\itemize{
\item Numbering are copied from the source document to the target document.
\item Styles are not copied. If styles in the source document do not exist
in the target document, the style specified in the \code{par_style_mapping},
\code{run_style_mapping} and \code{tbl_style_mapping} arguments will be used instead.
If no mapping is provided, the default style will be used and a warning is emitted.
}
}
\examples{
library(officer)

# example file from the package
file_input <- system.file(
  package = "officer",
  "doc_examples/example.docx"
)

# create a new rdocx document
x <- read_docx()

# import content from file_input
x <- body_import_docx(
  x = x,
  src = file_input,
  # style mapping for paragraphs and tables
  par_style_mapping = list(
    "Normal" = c("List Paragraph")
  ),
  tbl_style_mapping = list(
    "Normal Table" = "Light Shading"
  )
)

# Create temporary file
tf <- tempfile(fileext = ".docx")
# write to file
print(x, target = tf)
}
\seealso{
Other functions for adding content: 
\code{\link{body_add_blocks}()},
\code{\link{body_add_break}()},
\code{\link{body_add_caption}()},
\code{\link{body_add_docx}()},
\code{\link{body_add_fpar}()},
\code{\link{body_add_gg}()},
\code{\link{body_add_img}()},
\code{\link{body_add_par}()},
\code{\link{body_add_plot}()},
\code{\link{body_add_table}()},
\code{\link{body_add_toc}()},
\code{\link{body_append_start_context}()}
}
\concept{functions for adding content}
