% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.R
\name{dsadmin.profile_enable}
\alias{dsadmin.profile_enable}
\title{Enable or disable a DataSHIELD profile}
\usage{
dsadmin.profile_enable(opal, name, enabled = TRUE)
}
\arguments{
\item{opal}{Opal object.}

\item{name}{Name of the profile.}

\item{enabled}{Default value is TRUE.}
}
\description{
Enable or disable a DataSHIELD profile
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.profile_create(o, name = 'survival', cluster = 'demo')
dsadmin.profile_enable(o, name = 'survival', enabled = TRUE)
opal.logout(o)
}
}
\seealso{
Other DataSHIELD profiles: 
\code{\link{dsadmin.profile}()},
\code{\link{dsadmin.profile_access}()},
\code{\link{dsadmin.profile_create}()},
\code{\link{dsadmin.profile_delete}()},
\code{\link{dsadmin.profile_exists}()},
\code{\link{dsadmin.profile_init}()},
\code{\link{dsadmin.profile_perm}()},
\code{\link{dsadmin.profile_perm_add}()},
\code{\link{dsadmin.profile_perm_delete}()},
\code{\link{dsadmin.profile_rparser}()},
\code{\link{dsadmin.profiles}()}
}
\concept{DataSHIELD profiles}
