% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fine_tuning.R
\name{fine_tuning}
\alias{fine_tuning}
\title{DataStream Class}
\description{
DataStream Class

DataStream Class
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{fine_tuning}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-fine_tuning-create}{\code{fine_tuning$create()}}
\item \href{#method-fine_tuning-list}{\code{fine_tuning$list()}}
\item \href{#method-fine_tuning-retrieve}{\code{fine_tuning$retrieve()}}
\item \href{#method-fine_tuning-cancel}{\code{fine_tuning$cancel()}}
\item \href{#method-fine_tuning-events}{\code{fine_tuning$events()}}
\item \href{#method-fine_tuning-clone}{\code{fine_tuning$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fine_tuning-create"></a>}}
\if{latex}{\out{\hypertarget{method-fine_tuning-create}{}}}
\subsection{Method \code{create()}}{
Creates a job that fine-tunes a specified model from a given dataset.
             Response includes details of the enqueued job including job status and
             the name of the fine-tuned models once complete.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fine_tuning$create(
  model,
  training_file,
  hyperparameters = list(n_epochs = 1),
  ...,
  verbosity = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character Required. The model ID.}

\item{\code{training_file}}{character Required. The file used for training.}

\item{\code{hyperparameters}}{list. The hyperparameters used for the fine-tuning job. include batch_size;learning_rate_multiplier;n_epochs.}

\item{\code{...}}{Additional parameters as required by the OpenAI API.For example:validation_file......}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Response indicating the success or failure of the fine-tuning job creation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fine_tuning-list"></a>}}
\if{latex}{\out{\hypertarget{method-fine_tuning-list}{}}}
\subsection{Method \code{list()}}{
List your organization's fine-tuning jobs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fine_tuning$list(verbosity = 0, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}

\item{\code{...}}{Additional parameters as required by the OpenAI API. For example:after,limit.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of paginated fine-tuning job objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fine_tuning-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-fine_tuning-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Get info about a fine-tuning job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fine_tuning$retrieve(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{character Required. The ID of the fine-tuning job.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The fine-tuning object with the given ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fine_tuning-cancel"></a>}}
\if{latex}{\out{\hypertarget{method-fine_tuning-cancel}{}}}
\subsection{Method \code{cancel()}}{
Immediately cancel a fine-tune job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fine_tuning$cancel(job_id, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{character Required. The ID of the fine-tuning job to cancel.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The cancelled fine-tuning object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fine_tuning-events"></a>}}
\if{latex}{\out{\hypertarget{method-fine_tuning-events}{}}}
\subsection{Method \code{events()}}{
Get status updates for a fine-tuning job.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fine_tuning$events(job_id, ..., verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{job_id}}{character Required. The ID of the fine-tuning job to get events for.}

\item{\code{...}}{Additional parameters as required by the OpenAI API. For example:after,limit.}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of fine-tuning event objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fine_tuning-clone"></a>}}
\if{latex}{\out{\hypertarget{method-fine_tuning-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{fine_tuning$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
