% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{pathling_read_bulk}
\alias{pathling_read_bulk}
\title{Create a data source from a FHIR Bulk Data Access API endpoint}
\usage{
pathling_read_bulk(
  pc,
  fhir_endpoint_url,
  output_dir,
  group_id = NULL,
  patients = NULL,
  types = NULL,
  output_format = "application/fhir+ndjson",
  since = NULL,
  elements = NULL,
  type_filters = NULL,
  include_associated_data = NULL,
  output_extension = "ndjson",
  timeout = NULL,
  max_concurrent_downloads = 10,
  auth_config = NULL
)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{fhir_endpoint_url}{The URL of the FHIR server to export from.}

\item{output_dir}{The directory to write the output files to.}

\item{group_id}{Optional group ID for group-level export.}

\item{patients}{Optional list of patient IDs for patient-level export.}

\item{types}{List of FHIR resource types to include.}

\item{output_format}{The format of the output data. Defaults to "application/fhir+ndjson".}

\item{since}{Only include resources modified after this timestamp.}

\item{elements}{List of FHIR elements to include.}

\item{type_filters}{FHIR search queries to filter resources.}

\item{include_associated_data}{Pre-defined set of FHIR resources to include.}

\item{output_extension}{File extension for output files. Defaults to "ndjson".}

\item{timeout}{Optional timeout duration in seconds.}

\item{max_concurrent_downloads}{Maximum number of concurrent downloads. Defaults to 10.}

\item{auth_config}{Optional authentication configuration list with the following possible elements:
\itemize{
  \item{enabled: Whether authentication is enabled (default: FALSE)}
  \item{client_id: The client ID to use for authentication}
  \item{private_key_jwk: The private key in JWK format}
  \item{client_secret: The client secret to use for authentication}
  \item{token_endpoint: The token endpoint URL}
  \item{use_smart: Whether to use SMART authentication (default: TRUE)}
  \item{use_form_for_basic_auth: Whether to use form-based basic auth (default: FALSE)}
  \item{scope: The scope to request}
  \item{token_expiry_tolerance: The token expiry tolerance in seconds (default: 120)}
}}
}
\value{
A DataSource object that can be used to run queries against the data.
}
\description{
Creates a data source by downloading data from a FHIR server that implements the FHIR Bulk Data 
Access API.
}
\examples{
\dontrun{
pc <- pathling_connect()

# Basic system-level export
data_source <- pc \%>\% pathling_read_bulk(
  fhir_endpoint_url = "https://bulk-data.smarthealthit.org/fhir",
  output_dir = "/tmp/bulk_export"
)

# Group-level export with filters
data_source <- pc \%>\% pathling_read_bulk(
  fhir_endpoint_url = "https://bulk-data.smarthealthit.org/fhir", 
  output_dir = "/tmp/bulk_export",
  group_id = "group-1",
  types = c("Patient", "Observation"),
  elements = c("id", "status"),
  since = as.POSIXct("2023-01-01")
)

# Patient-level export with auth
data_source <- pc \%>\% pathling_read_bulk(
  fhir_endpoint_url = "https://bulk-data.smarthealthit.org/fhir",
  output_dir = "/tmp/bulk_export", 
  patients = c(
    "123",  # Just the ID portion
    "456"
  ),
  auth_config = list(
    enabled = TRUE,
    client_id = "my-client-id",
    private_key_jwk = '{ "kty":"RSA", ...}',
    scope = "system/*.read"
  )
)

pathling_disconnect(pc)
}
}
\seealso{
\href{https://pathling.csiro.au/docs/libraries/io#fhir-bulk-data-api}{Pathling documentation - Reading from Bulk Data API}

Other data source functions: 
\code{\link{pathling_read_bundles}()},
\code{\link{pathling_read_datasets}()},
\code{\link{pathling_read_delta}()},
\code{\link{pathling_read_ndjson}()},
\code{\link{pathling_read_parquet}()},
\code{\link{pathling_read_tables}()}
}
\concept{data source functions}
