% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Simulate synthetic control data}
\usage{
simulate_data(
  N_donor = 50,
  N_covar = 5,
  N_pre = 12,
  N_post = 6,
  N_nonzero = 4,
  treatment_effect = 1,
  sd_resid_X1 = 0.1,
  sd_resid_Z1 = 0.1,
  sd_resid_Y1 = 0.1
)
}
\arguments{
\item{N_donor}{number of donors}

\item{N_covar}{number of covariates}

\item{N_pre}{number of pre-intervention timepoints}

\item{N_post}{number of post-intervention timepoints}

\item{N_nonzero}{number of true nonzero weights}

\item{treatment_effect}{the size of the true treatment effect}

\item{sd_resid_X1}{the residual standard deviation of X1}

\item{sd_resid_Z1}{the residual standard deviation of Z1}

\item{sd_resid_Y1}{the residual standard deviation of Y1}
}
\value{
A list with the following elements
\itemize{
\item w the true unit weights
\item X0 the donor unit covariates
\item X1 the treated unit covariates
\item Z0 the donor unit pre-intervention outcomes
\item Z1 the treated unit pre-intervention outcomes
\item Y0 the donor unit post-intervention outcomes
\item Y1 the treated unit post-intervention outcomes
}
}
\description{
This function simulates a basic form of synthetic control
data, mainly for testing purposes. This
}
\details{
Note that treatment effect can be a single number, but
it may also be a vector of length N_post, indicating
the effect size at each post-intervention measurement
occasion.
}
\examples{
# simulate data with an effect of 0.8 SD
dat <- simulate_data(treatment_effect = 0.8)

plot(
  NA,
  ylim = c(-3, 3),
  xlim = c(1, 18),
  main = "Simulated data",
  ylab = "Outcome value"
)
for (n in 1:ncol(dat$Z0))
  lines(1:18, c(dat$Z0[, n], dat$Y0[, n]), col = "grey")
lines(1:18, c(dat$Z1, dat$Y1))
lines(1:18, rbind(dat$Z0, dat$Y0) \%*\% dat$w, lty = 2)
abline(v = length(dat$Z1) + 0.5, lty = 3)
legend(
  x = "bottomleft",
  legend = c(
    "Donor units",
    "Treated unit",
    "True synth. control",
    "Intervention time"
  ),
  lty = c(1, 1, 2, 3),
  col = c("grey", "black", "black", "black")
)
}
\seealso{
\code{\link[=pensynth]{pensynth()}}, \code{\link[=cv_pensynth]{cv_pensynth()}}, \code{\link[=placebo_test]{placebo_test()}}
}
