% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_quantize.R
\name{quantize}
\alias{quantize}
\title{Stratified randomization of community matrix}
\usage{
quantize(x = NULL, ...)
}
\arguments{
\item{x}{Community matrix with species in rows, sites in columns,
and nonnegative quantities in cells.}

\item{...}{Additional arguments passed to \code{nullcat::quantize()}.}
}
\value{
A randomized version of \code{x}.
}
\description{
This is a simple wrapper around \code{nullcat::quantize()}, included in
\code{phylospatial} mainly for backward compatibility.
}
\details{
The nullcat \link[nullcat]{quantize} routine involves three steps: converting a
quantitative matrix to categorical strata, permuting the resulting categorical
matrix using one of several categorical null model algorithms, and mapping the
randomized categories back to quantitative values. Supply arguments via \code{...}
to control options for each of these stages.
}
\examples{
\donttest{
if (requireNamespace("nullcat", quietly = TRUE)) {
      # example quantitative community matrix
      comm <- matrix(runif(2500), 50)

      # examples of different quantize usage
      rand <- quantize(comm)
      rand <- quantize(comm, n_strata = 4, transform = sqrt, fixed = "row")
      rand <- quantize(comm, method = "swapcat", n_iter = 500)
}
}
}
