% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/price_relative.R
\name{price_relative}
\alias{price_relative}
\alias{price_relative.default}
\alias{price_relative.data.frame}
\title{Calculate period-over-period price relatives}
\usage{
price_relative(x, ...)

\method{price_relative}{default}(x, ..., period, product)

\method{price_relative}{data.frame}(x, formula, ...)
}
\arguments{
\item{x}{Either a numeric vector (or something that can be coerced into one)
or data frame of prices.}

\item{...}{Further arguments passed to or used by methods.}

\item{period}{A factor, or something that can be coerced into one, that
gives the corresponding time period for each element in \code{x}. The
ordering of time periods follows the levels of \code{period} to agree with
\code{\link[=cut.Date]{cut()}}.}

\item{product}{A factor, or something that can be coerced into one, that
gives the corresponding product identifier for each element in \code{x}.}

\item{formula}{A two-sided formula with prices on the left-hand
side, and time periods and products (in that order) on the
right-hand side.}
}
\value{
A numeric vector of price relatives, with \code{product} as names.
}
\description{
Construct period-over-period price relatives from information on prices and
products over time.
}
\examples{
price_relative(
  1:6,
  period = rep(1:2, each = 3),
  product = rep(letters[1:3], 2)
)

}
\seealso{
\code{\link[gpindex:back_period]{gpindex::back_period()}} to get only the back price.

\code{\link[gpindex:back_period]{gpindex::base_period()}} for making fixed-base price relatives.

\code{\link[=carry_forward]{carry_forward()}} and \code{\link[=shadow_price]{shadow_price()}} to impute missing prices.

\code{\link[gpindex:outliers]{gpindex::outliers}} for methods to identify outliers with price relatives.
}
