% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{ncases_by}
\alias{ncases_by}
\title{Number of Cases in Data by Group}
\usage{
ncases_by(
  data,
  vrb.nm = str2str::pick(names(data), val = grp.nm, not = TRUE),
  grp.nm,
  sep = ".",
  ov.min = 1L,
  prop = TRUE,
  inclusive = TRUE
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
set of variables to base the ncases on.}

\item{grp.nm}{character vector of colnames from \code{data} specifying the
grouping variables.}

\item{sep}{character vector of length 1 specifying what string to use to
separate the groups when naming the return object. \code{sep} is only used
if \code{grp.nm} has length > 1 (aka multiple grouping variables)}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{length(vrb.nm)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the case
should be included if the frequency of observed values in a row is exactly
equal to \code{ov.min}.}
}
\value{
atomic vector with names = \code{unique(interaction(data[grp.nm], sep
  = sep))} and length = \code{length(unique(interaction(data[grp.nm], sep =
  sep)))} providing the ncases for each group.
}
\description{
\code{ncases_by} computes the ncases of a data.frame by group. Through the
use of the \code{ov.min}, \code{prop}, and \code{inclusive} arguments, the
user can specify how many missing values are allowed in a row for it to be
counted. \code{ncases_by} is simply a wrapper for \code{ncases} +
\code{agg_dfm}.
}
\examples{

# one grouping variables
tmp_nm <- c("outcome","case","session","trt_time")
dat <- as.data.frame(lmeInfo::Bryant2016)[tmp_nm]
stats_by <- psych::statsBy(dat,
   group = "case") # requires you to include "case" column in dat
ncases_by(data = dat, grp.nm = "case")
dat2 <- as.data.frame(ChickWeight)
ncases_by(data = dat2, grp.nm = "Chick")

# two grouping variables
tmp <- reshape(psych::bfi[1:10, ], varying = 1:25, timevar = "item",
   ids = row.names(psych::bfi)[1:10], direction = "long", sep = "")
tmp_nm <- c("id","item","N","E","C","A","O") # Roxygen runs the whole script
dat3 <- str2str::stack2(tmp[tmp_nm], select.nm = c("N","E","C","A","O"),
   keep.nm = c("id","item"))
ncases_by(dat3, grp.nm = c("id","vrb_names"))

}
\seealso{
\code{\link{nrow_by}}
   \code{\link{ncases}}
   \code{\link{agg_dfm}}
}
