% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{glance.highd_vis_model}
\alias{glance.highd_vis_model}
\title{Generate evaluation metrics for a hex_model object}
\usage{
\method{glance}{highd_vis_model}(x, highd_data, ...)
}
\arguments{
\item{x}{An object of class \code{hex_model} generated by \code{fit_highd_model()}.}

\item{highd_data}{A data frame or tibble containing the original high-dimensional data with an \code{ID} column.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A tibble contains Error, and MSE values.
}
\description{
This function computes evaluation metrics (Error and RMSE) by comparing
the high-dimensional data to the predictions obtained from a hex_model object.
}
\examples{
# Assuming 'fit' is a hex_model object and 'scurve' contains the original data:
fit <- fit_highd_model(highd_data = scurve, nldr_data = scurve_umap, b1 = 30,
q = 0.1, hd_thresh = 5)
glance(fit, highd_data = scurve)

}
