% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{calc_2d_dist}
\alias{calc_2d_dist}
\title{Calculate 2-D Euclidean distances between vertices}
\usage{
calc_2d_dist(
  trimesh_data,
  select_vars = c("from", "to", "x_from", "y_from", "x_to", "y_to", "from_count",
    "to_count", "distance")
)
}
\arguments{
\item{trimesh_data}{A tibble that contains the x and y coordinates of start
and end points.}

\item{select_vars}{selected columns in the resulting data frame.}
}
\value{
A tibble with columns for the starting point, ending point,
and calculated distances.
}
\description{
This function calculates the 2-D distances between pairs of points in a data frame.
}
\examples{
tr_from_to_df <- scurve_model_obj$trimesh_data
calc_2d_dist(trimesh_data = tr_from_to_df)

}
