% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_estimate.R
\name{tau_estimate}
\alias{tau_estimate}
\title{Estimate tau parameter for \code{ratemeter_sim}}
\usage{
tau_estimate(pct_eq, t_eq)
}
\arguments{
\item{pct_eq}{Percent equilibrium}

\item{t_eq}{Time, in seconds, to the given percent equilibrium is achieved.}
}
\value{
tau, the time constant, in seconds.
}
\description{
If the time constant is not known, but the vendor specifies that
the ratemeter will reach some percentage of equilibrium in some number of
seconds, use this function to estimate tau.
}
\examples{
tau_estimate(pct_eq = 90, t_eq = 22)
}
\seealso{
Other rad measurements: 
\code{\link{air_dens_cf}()},
\code{\link{disk_to_disk_solid_angle}()},
\code{\link{neutron_geom_cf}()},
\code{\link{scaler_sim}()}
}
\concept{rad measurements}
