% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsMappingMethods.R, R/exportMappings.R,
%   R/importMappings.R
\name{mappingMethods}
\alias{mappingMethods}
\alias{exportMappings}
\alias{importMappings}
\alias{exportMappings.redcapApiConnection}
\alias{importMappings.redcapApiConnection}
\title{Export and Import Instrument-Event Mappings}
\usage{
exportMappings(rcon, arms, ...)

importMappings(rcon, data, ...)

\method{exportMappings}{redcapApiConnection}(rcon, arms = NULL, ...)

\method{importMappings}{redcapApiConnection}(rcon, data, ...)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{arms}{\code{integerish} or \code{character}. A vector of arm numbers. When
given, mappings are only exported for the given arms.}

\item{data}{\code{data.frame} with columns \code{arm_num}, \code{unique_event_name},
and \code{form}. See Details}

\item{...}{Arguments to pass to other methods}
}
\value{
\code{exportMappings} returns a data frame with the columns:\tabular{ll}{
    \tab  \cr
   \code{arm_num} \tab The arm number for the unique event mapped to the instrument. \cr
   \code{unique_event_name} \tab The unique event name to which the instrument is assigned. \cr
   \code{form} \tab The REDCap assigned instrument name mapped to the event. \cr
}


\code{importMappings} invisible returns the number of mappings added or edited.
}
\description{
These methods enable the user to export and add/modify the
mappings between instruments and events. The information provided
with the methods corresponds to what is provided in the
'Designate Instruments for My Events' page in the user interface.
}
\details{
These methods are only applicable to longitudinal projects.
If the project information reports that the project is not longitudinal,
a data frame with 0 rows is returned without calling the API.
}
\section{Functions}{
\itemize{
\item \code{exportMappings()}: Export instrument-event mappings.

\item \code{importMappings()}: Import instrument-event mappings to the project.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Export all mappings
exportMappings(rcon)

# Export mappings for a specific arm
exportMappings(rcon, 
               arms = 1)
               
# Import mappings
NewMapping <- 
  data.frame(arm_num = c(1, 1, 2), 
             unique_event_name = c("event_1_arm_1", 
                                   "event_2_arm_1", 
                                   "event_1_arm_2"), 
             form = c("registration", 
                      "follow_up", 
                      "registration"))

importMapping(rcon, 
              data = NewMapping)
}

}
\seealso{
\code{\link[=exportFieldNames]{exportFieldNames()}},\cr
\code{\link[=exportInstruments]{exportInstruments()}},\cr
\code{\link[=exportMetaData]{exportMetaData()}},\cr
\code{\link[=importMetaData]{importMetaData()}}, \cr
\code{\link[=exportPdf]{exportPdf()}}
}
