% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{tm}
\alias{tm}
\alias{tm.character}
\alias{tm.formula}
\alias{tm.fmls}
\alias{tm.tm}
\alias{tm.default}
\alias{is_tm}
\title{Create vectorized terms}
\usage{
tm(x = unspecified(), ...)

\method{tm}{character}(
  x,
  role = character(),
  side = character(),
  label = character(),
  group = integer(),
  type = character(),
  distribution = character(),
  description = character(),
  transformation = character(),
  ...
)

\method{tm}{formula}(
  x,
  role = formula(),
  label = formula(),
  group = formula(),
  type = formula(),
  distribution = formula(),
  description = formula(),
  transformation = formula(),
  ...
)

\method{tm}{fmls}(x, ...)

\method{tm}{tm}(x, ...)

\method{tm}{default}(x = unspecified(), ...)

is_tm(x)
}
\arguments{
\item{x}{An object that can be coerced to a \code{tm} object.}

\item{...}{Arguments to be passed to or from other methods}

\item{role}{Specific roles the variable plays within the formula. These are
of particular importance, as they serve as special terms that can effect
how a formula is interpreted. Please see the \emph{Roles} section below for
further details. The options for roles are as below:
\itemize{
\item outcome
\item exposure
\item predictor
\item confounder
\item mediator
\item interaction
\item strata
\item group
\item unknown
}}

\item{side}{Which side of a formula should the term be on. Options are
\code{c("left", "right", "meta", "unknown")}. The \emph{meta} option refers to a term
that may apply globally to other terms.}

\item{label}{Display-quality label describing the variable}

\item{group}{Grouping variable name for modeling or placing terms together.
An integer value is given to identify which group the term will be in. The
hierarchy will be \code{1} to \code{n} incrementally.}

\item{type}{Type of variable, either categorical (qualitative) or
continuous (quantitative)}

\item{distribution}{How the variable itself is more specifically
subcategorized, e.g. ordinal, continuous, dichotomous, etc}

\item{description}{Option for further descriptions or definitions needed for
the tm, potentially part of a data dictionary}

\item{transformation}{Modification of the term to be applied when
combining with data}
}
\value{
A \code{tm} object, which is a series of individual terms with
corresponding attributes, including the role, formula side, label,
grouping, and other related features.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\details{
A vectorized term object that allows for additional information to be carried
with the variable name.

This is not meant to replace traditional \code{\link[stats:terms]{stats::terms()}}, but to supplement
it using additional information that is more informative for causal modeling.
}
\section{Roles}{
Specific roles the variable plays within the formula. These are of particular
importance, as they serve as special terms that can effect how a formula is
interpreted.\tabular{lll}{
   Role \tab Shortcut \tab Description \cr
   outcome \tab \code{.o(...)} \tab \strong{outcome} ~ exposure \cr
   exposure \tab \code{.x(...)} \tab outcome ~ \strong{exposure} \cr
   predictor \tab \code{.p(...)} \tab outcome ~ exposure + \strong{predictor} \cr
   confounder \tab \code{.c(...)} \tab outcome + exposure ~ \strong{confounder} \cr
   mediator \tab \code{.m(...)} \tab outcome \strong{mediator} exposure \cr
   interaction \tab \code{.i(...)} \tab outcome ~ exposure * \strong{interaction} \cr
   strata \tab \code{.s(...)} \tab outcome ~ exposure / \strong{strata} \cr
   group \tab \code{.g(...)} \tab outcome ~ exposure + \strong{group} \cr
   \emph{unknown} \tab \code{-} \tab not yet assigned \cr
}


Formulas can be condensed by applying their specific role to individual runes
as a function/wrapper. For example, \code{y ~ .x(x1) + x2 + x3}. This would
signify that \code{x1} has the specific role of an \emph{exposure}.

Grouped variables are slightly different in that they are placed together in
a hierarchy or tier. To indicate the group and the tier, the shortcut can
have an \code{integer} following the \code{.g}. If no number is given, then it is
assumed they are all on the same tier. Ex: \code{y ~ x1 + .g1(x2) + .g1(x3)}

\strong{Warning}: Only a single shortcut can be applied to a variable within a
formula directly.
}

\section{Pluralized Labeling Arguments}{
For a single argument, e.g. for the \code{tm.formula()} method, such as to
identify variable \strong{X} as an exposure, a \code{formula} should be given with the
term of interest on the \emph{LHS}, and the description or instruction on the
\emph{RHS}. This would look like \code{role = "exposure" ~ X}.

For the arguments that would be dispatched for objects that are plural, e.g.
containing multiple terms, each \code{formula()} should be placed within a
\code{list()}. For example, the \strong{role} argument would be written:

\code{role = list(X ~ "exposure", M ~ "mediator", C ~ "confounder")}

Further implementation details can be seen in the implementation of
\code{\link[=labeled_formulas_to_named_list]{labeled_formulas_to_named_list()}}.
}

