% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glasso_CV.R
\name{cvglasso}
\alias{cvglasso}
\title{Cross validation to chose tuning parameter of glasso}
\usage{
cvglasso(
  data,
  k = 10,
  covest = cov,
  rhos = seq(0.1, 1, 0.1),
  evaluation = negLLrobOmega,
  ...
)
}
\arguments{
\item{data}{The full dataset, should be a matrix or a data.frame, row as sample}

\item{k}{number of folds}

\item{covest}{a *function* or name of a function (string) that takes a matrix to estimate covariance}

\item{rhos}{a vector of tuning parameter to be tested}

\item{evaluation}{a *function* or name of a function (string) that takes only two arguments, the estimated covariance and the test covariance, when NULL, we use negative log likelihood on test sets}

\item{...}{extra arguments send to glasso}
}
\value{
a matrix with k rows, each row is the evaluation loss of that fold
}
\description{
This routine use k fold cross validation to chose tuning parameter
}
\examples{
cvglasso(matrix(rnorm(100),20,5))
}
