% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_embedding.R
\name{align_embedding}
\alias{align_embedding}
\title{Gene Network Reconstruction and Alignment}
\usage{
align_embedding(
  gene_data1,
  gene_node1,
  E1,
  gene_data2,
  gene_node2,
  E2,
  dirpath = tempdir(),
  save_file = TRUE,
  d = 100
)
}
\arguments{
\item{gene_data1}{The information for genes in state1, must have a col names "gene_name".}

\item{gene_node1}{Gene ids that are associated with other peaks or genes in state1.}

\item{E1}{Embedding representations of peaks and genes in state1.}

\item{gene_data2}{The information for genes in state2, must have a col names "gene_name".}

\item{gene_node2}{Gene ids that are associated with other peaks or genes in state2.}

\item{E2}{Embedding representations of peaks and genes in state2.}

\item{dirpath}{The folder path to read or write file}

\item{save_file}{Logical, whether to save the output to a file.}

\item{d}{The dimension of latent space.}
}
\value{
A list containing the following elements:
\describe{
\item{\code{E_g2}}{Low-dimensional embedding representations of genes under the two conditions.}
\item{\code{common_genes}}{Genes shared between both conditions and used in the analysis.}
\item{\code{diffRegulation}}{A list of differential regulatory information for each gene.}
}
}
\description{
Reconstruct gene networks via epsilon-NN and compare conditions using manifold alignment implemented in scTenifoldNet.
}
\examples{
\donttest{
library(scPOEM)
library(monocle)
dirpath <- "./example_data"
# Download compare mode example data
data(example_data_compare)
data_S1 <- example_data_compare$S1
data_S2 <- example_data_compare$S2
gg_net1 <- GGN(data_S1$Y, file.path(dirpath, "compare/S1"), save_file=FALSE)
pp_net1 <- PPN(data_S1$X, data_S1$peak_data, data_S1$cell_data,
               data_S1$genome, file.path(dirpath, "compare/S1"), save_file=FALSE)

net_Lasso1 <- PGN_Lasso(data_S1$X, data_S1$Y,
                        data_S1$gene_data, data_S1$neibor_peak,
                        file.path(dirpath, "compare/S1"), save_file=FALSE)
net_RF1 <- PGN_RF(data_S1$X, data_S1$Y, data_S1$gene_data,
                  data_S1$neibor_peak, file.path(dirpath, "compare/S1"), save_file=FALSE)
net_XGB1 <- PGN_XGBoost(data_S1$X, data_S1$Y,
                        data_S1$gene_data, data_S1$neibor_peak,
                        file.path(dirpath, "compare/S1"), save_file=FALSE)
pg_net_list1 <- list(net_Lasso1, net_RF1, net_XGB1)
E_result_S1 <- pg_embedding(gg_net1, pp_net1, pg_net_list1,
               file.path(dirpath, "compare/S1"), save_file=FALSE)

gg_net2 <- GGN(data_S2$Y, file.path(dirpath, "compare/S2"), save_file=FALSE)
pp_net2 <- PPN(data_S2$X, data_S2$peak_data,
               data_S2$cell_data, data_S2$genome,
               file.path(dirpath, "compare/S2"), save_file=FALSE)
net_Lasso2 <- PGN_Lasso(data_S2$X, data_S2$Y,
                        data_S2$gene_data, data_S2$neibor_peak,
                        file.path(dirpath, "compare/S2"), save_file=FALSE)
net_RF2 <- PGN_RF(data_S2$X, data_S2$Y, data_S2$gene_data,
                  data_S2$neibor_peak, file.path(dirpath, "compare/S2"), save_file=FALSE)
net_XGB2 <- PGN_XGBoost(data_S2$X, data_S2$Y,
                        data_S2$gene_data, data_S2$neibor_peak,
                        file.path(dirpath, "compare/S2"), save_file=FALSE)
pg_net_list2 <- list(net_Lasso2, net_RF2, net_XGB2)
E_result_S2 <- pg_embedding(gg_net2, pp_net2, pg_net_list2,
               file.path(dirpath, "compare/S2"), save_file=FALSE)

compare_result <- align_embedding(data_S1$gene_data,
                                  E_result_S1$gene_node,
                                  E_result_S1$E,
                                  data_S2$gene_data,
                                  E_result_S2$gene_node,
                                  E_result_S2$E,
                                  file.path(dirpath, "compare/compare"),
                                  save_file=FALSE)
}

}
