% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curve_params_one_ab.R
\name{plot_curve_params_one_ab}
\alias{plot_curve_params_one_ab}
\title{Graph an antibody decay curve model}
\usage{
plot_curve_params_one_ab(
  object,
  verbose = FALSE,
  alpha = 0.4,
  n_curves = 100,
  n_points = 1000,
  log_x = FALSE,
  log_y = TRUE,
  iters_to_graph = seq_len(min(n_curves, nrow(object))),
  xlim = c(10^-1, 10^3.1),
  ...
)
}
\arguments{
\item{object}{a \code{\link[=data.frame]{data.frame()}} of curve parameters (one or more MCMC samples)}

\item{verbose}{verbose output}

\item{alpha}{(passed to \code{\link[ggplot2:geom_function]{ggplot2::geom_function()}})
how transparent the curves should be:
\itemize{
\item 0 = fully transparent (invisible)
\item 1 = fully opaque
}}

\item{n_curves}{how many curves to plot (see details).}

\item{n_points}{Number of points to interpolate along the x axis
(passed to \code{\link[ggplot2:geom_function]{ggplot2::geom_function()}})}

\item{log_x}{should the x-axis be on a logarithmic scale (\code{TRUE})
or linear scale (\code{FALSE}, default)?}

\item{log_y}{should the Y-axis be on a logarithmic scale
(default, \code{TRUE}) or linear scale (\code{FALSE})?}

\item{iters_to_graph}{which MCMC iterations in \code{curve_params} to plot
(overrides \code{n_curves}).}

\item{xlim}{range of x values to graph}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:geom_function]{ggplot2::geom_function}}
  \describe{
    \item{\code{mapping}}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}
    \item{\code{data}}{Ignored by \code{stat_function()}, do not use.}
    \item{\code{stat}}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}
    \item{\code{position}}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}
    \item{\code{arrow}}{Arrow specification, as created by \code{\link[grid:arrow]{grid::arrow()}}.}
    \item{\code{arrow.fill}}{fill colour to use for the arrow head (if closed). \code{NULL}
means use \code{colour} aesthetic.}
    \item{\code{lineend}}{Line end style (round, butt, square).}
    \item{\code{linejoin}}{Line join style (round, mitre, bevel).}
    \item{\code{linemitre}}{Line mitre limit (number greater than 1).}
    \item{\code{na.rm}}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
    \item{\code{show.legend}}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}
    \item{\code{inherit.aes}}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}
  }}
}
\value{
a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object
}
\description{
Graph an antibody decay curve model
}
\details{
\subsection{\code{n_curves} and \code{iters_to_graph}}{

In most cases, \code{object} will contain too many rows of MCMC
samples for all of these samples to be plotted at once.
\itemize{
\item Setting the  \code{n_curves} argument to a value smaller than the
number of rows in \code{curve_params} will cause this function to select
the first \code{n_curves} rows to graph.
\item Setting \code{n_curves} larger than the number of rows in ` will
result all curves being plotted.
\item If the user directly specifies the \code{iters_to_graph} argument,
then \code{n_curves} has no effect.
}
}
}
\examples{
\donttest{
library(dplyr) # loads the `\%>\%` operator and `dplyr::filter()`

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso == ("HlyE_IgG")) \%>\%
  serocalculator:::plot_curve_params_one_ab()

  curve
}
}
\keyword{internal}
