/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SerializableWritable;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import sparklyr.DFCollectionUtils$;
import sparklyr.Logger;
import sparklyr.PartitionUtils$;
import sparklyr.RDSCollector$;
import sparklyr.RUtils$;

public final class RDSCollector$ {
    public static final RDSCollector$ MODULE$;

    static {
        new RDSCollector$();
    }

    public void collect(Dataset<Row> df, Seq<String> outputFiles, SparkSession spark) {
        int numPartitions = df.rdd().getNumPartitions();
        if (outputFiles.length() != numPartitions) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Number of output file(s) does not match input dataframe's number of partitions (").append((Object)BoxesRunTime.boxToInteger((int)outputFiles.length())).append((Object)" vs. ").append((Object)BoxesRunTime.boxToInteger((int)numPartitions)).append((Object)").").toString());
        }
        Tuple2<Dataset<Row>, Tuple2<String, String>[]> tuple2 = DFCollectionUtils$.MODULE$.prepareDataFrameForCollection(df);
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            Dataset transformedDf = (Dataset)tuple22._1();
            Tuple2[] dtypes = (Tuple2[])tuple22._2();
            transformedDf.cache();
            int[] partitionSizes = new int[numPartitions];
            Predef$.MODULE$.refArrayOps((Object[])PartitionUtils$.MODULE$.computePartitionSizes((Dataset<Row>)transformedDf)).foreach((Function1)new Serializable(partitionSizes){
                public static final long serialVersionUID = 0L;
                private final int[] partitionSizes$1;

                public final void apply(int[] p) {
                    int partitionSize;
                    int partitionId = p[0];
                    this.partitionSizes$1[partitionId] = partitionSize = p[1];
                }
                {
                    this.partitionSizes$1 = partitionSizes$1;
                }
            });
            this.writeHeaders(transformedDf.sqlContext().sparkContext(), outputFiles, (Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])dtypes));
            String[] cols = transformedDf.columns();
            Configuration hadoopConf = transformedDf.sqlContext().sparkContext().hadoopConfiguration();
            SerializableWritable serializedHadoopConf = new SerializableWritable((Writable)hadoopConf);
            Predef$ predef$ = Predef$.MODULE$;
            RichInt$.MODULE$.until$extension0(0, cols.length).map((Function1)new Serializable(outputFiles, transformedDf, dtypes, partitionSizes, cols, serializedHadoopConf){
                public static final long serialVersionUID = 0L;
                public final Seq outputFiles$1;
                private final Dataset transformedDf$1;
                public final Tuple2[] dtypes$1;
                public final int[] partitionSizes$1;
                private final String[] cols$1;
                public final SerializableWritable serializedHadoopConf$1;

                public final void apply(int idx) {
                    this.apply$mcVI$sp(idx);
                }

                public void apply$mcVI$sp(int idx) {
                    Dataset colDf = this.transformedDf$1.select(this.cols$1[idx], (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
                    colDf.cache();
                    colDf.foreachPartition((Function1)new Serializable(this, idx){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.collect.1 $outer;
                        private final int idx$1;

                        /*
                         * WARNING - void declaration
                         */
                        public final void apply(Iterator<Row> iter) {
                            FileSystem fs = FileSystem.get((Configuration)((Configuration)this.$outer.serializedHadoopConf$1.value()));
                            FSDataOutputStream fos = fs.create(new Path(new StringBuilder().append((Object)((String)this.$outer.outputFiles$1.apply(TaskContext$.MODULE$.getPartitionId()))).append((Object)".col_").append((Object)BoxesRunTime.boxToInteger((int)this.idx$1)).toString()));
                            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
                            DataOutputStream dos = new DataOutputStream(bos);
                            try {
                                RUtils$.MODULE$.writeColumn(dos, this.$outer.partitionSizes$1[TaskContext$.MODULE$.getPartitionId()], iter, (String)this.$outer.dtypes$1[this.idx$1]._2());
                            }
                            catch (Throwable throwable) {
                                void var5_3;
                                void var4_4;
                                void var3_5;
                                var3_5.close();
                                var4_4.close();
                                var5_3.close();
                                throw throwable;
                            }
                            dos.close();
                            bos.close();
                            fos.close();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.idx$1 = idx$1;
                        }
                    });
                }
                {
                    this.outputFiles$1 = outputFiles$1;
                    this.transformedDf$1 = transformedDf$1;
                    this.dtypes$1 = dtypes$1;
                    this.partitionSizes$1 = partitionSizes$1;
                    this.cols$1 = cols$1;
                    this.serializedHadoopConf$1 = serializedHadoopConf$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Logger logger = new Logger("RDSCollector", 0);
            FileSystem fs = FileSystem.get((Configuration)hadoopConf);
            outputFiles.foreach((Function1)new Serializable(cols, logger, fs){
                public static final long serialVersionUID = 0L;
                private final String[] cols$1;
                public final Logger logger$1;
                public final FileSystem fs$1;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void apply(String o) {
                    Predef$ predef$ = Predef$.MODULE$;
                    String[] inputs = (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{new StringBuilder().append((Object)o).append((Object)".hdr").toString()}).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(0, this.cols$1.length).map((Function1)new Serializable(this, o){
                        public static final long serialVersionUID = 0L;
                        private final String o$1;

                        public final String apply(int idx) {
                            return new StringBuilder().append((Object)this.o$1).append((Object)".col_").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString();
                        }
                        {
                            this.o$1 = o$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                    Path[] paths = (Path[])Predef$.MODULE$.refArrayOps((Object[])inputs).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(String x) {
                            return new Path(x);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
                    FileSystem fileSystem = this.fs$1;
                    if (fileSystem instanceof LocalFileSystem) {
                        java.nio.file.Path[] localPaths = (java.nio.file.Path[])Predef$.MODULE$.refArrayOps((Object[])inputs).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final java.nio.file.Path apply(String x) {
                                return Paths.get(new URI(x).getPath(), new String[0]);
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(java.nio.file.Path.class)));
                        SeekableByteChannel ch = Files.newByteChannel(Paths.get(new URI(o).getPath(), new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                        try {
                            Predef$.MODULE$.refArrayOps((Object[])localPaths).foreach((Function1)new Serializable(this, ch){
                                public static final long serialVersionUID = 0L;
                                private final SeekableByteChannel ch$1;

                                /*
                                 * WARNING - void declaration
                                 */
                                public final int apply(java.nio.file.Path path) {
                                    int n;
                                    FileChannel pch = FileChannel.open(path, StandardOpenOption.READ);
                                    try {
                                        MappedByteBuffer buf = pch.map(FileChannel.MapMode.READ_ONLY, 0L, pch.size());
                                        n = this.ch$1.write(buf);
                                    }
                                    catch (Throwable throwable) {
                                        void var2_2;
                                        var2_2.close();
                                        throw throwable;
                                    }
                                    pch.close();
                                    return n;
                                }
                                {
                                    this.ch$1 = ch$1;
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            void var8_7;
                            var8_7.close();
                            throw throwable;
                        }
                        ch.close();
                    } else {
                        Path dst = new Path(o);
                        this.fs$1.createNewFile(dst);
                        this.fs$1.concat(dst, paths);
                    }
                    Predef$.MODULE$.refArrayOps((Object[])paths).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.collect.3 $outer;

                        public final Object apply(Path path) {
                            Boolean bl;
                            try {
                                bl = BoxesRunTime.boxToBoolean((boolean)this.$outer.fs$1.delete(path, false));
                            }
                            catch (Throwable throwable) {
                                this.$outer.logger$1.logWarning(new StringBuilder().append((Object)"Failed to delete temporary file ").append((Object)path).append((Object)": ").append((Object)throwable.toString()).toString());
                                bl = BoxedUnit.UNIT;
                            }
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.cols$1 = cols$1;
                    this.logger$1 = logger$1;
                    this.fs$1 = fs$1;
                }
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    private void writeHeaders(SparkContext sc, Seq<String> outputFiles, Seq<Tuple2<String, String>> dtypes) {
        FileSystem fs = FileSystem.get((Configuration)sc.hadoopConfiguration());
        ((IterableLike)outputFiles.map((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$2;

            public final FSDataOutputStream apply(String p) {
                return this.fs$2.create(new Path(new StringBuilder().append((Object)p).append((Object)".hdr").toString()));
            }
            {
                this.fs$2 = fs$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(dtypes){
            public static final long serialVersionUID = 0L;
            private final Seq dtypes$2;

            /*
             * WARNING - void declaration
             */
            public final void apply(FSDataOutputStream fos) {
                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)fos);
                DataOutputStream dos = new DataOutputStream(bos);
                try {
                    RUtils$.MODULE$.writeXdrHeader(dos);
                    RUtils$.MODULE$.writeDataFrameHeader(dos, (Seq<Tuple2<String, String>>)this.dtypes$2);
                }
                catch (Throwable throwable) {
                    void var2_2;
                    void var3_3;
                    var3_3.close();
                    var2_2.close();
                    fos.close();
                    throw throwable;
                }
                dos.close();
                bos.close();
                fos.close();
            }
            {
                this.dtypes$2 = dtypes$2;
            }
        });
    }

    private RDSCollector$() {
        MODULE$ = this;
    }
}

