/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.feature.Bucketizer;
import org.apache.spark.ml.feature.QuantileDiscretizerBase;
import org.apache.spark.ml.feature.WeightedQuantileDiscretizer$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.param.StringArrayParam;
import org.apache.spark.ml.param.shared.HasHandleInvalid;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCols;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCols;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import sparklyr.WeightedQuantileSummaries$;

@ScalaSignature(bytes="\u0006\u0005\u00055f\u0001\u0002\u000e\u001c\u0005\u0019B\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t%\u0011\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005\u0005\")\u0001\u000b\u0001C\u0001#\")\u0001\u000b\u0001C\u0001)\"9Q\u000b\u0001b\u0001\n\u000b1\u0006BB.\u0001A\u00035q\u000bC\u0003]\u0001\u0011\u0015Q\fC\u0003c\u0001\u0011\u00051\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003n\u0001\u0011\u0005a\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003t\u0001\u0011\u0005A\u000fC\u0003w\u0001\u0011\u0005q\u000fC\u0003z\u0001\u0011\u0005!\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ti\u0001\u0001C!\u0003\u001fAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u0002N\u0001!I!a\u0014\t\u000f\u0005]\u0003\u0001\"\u0011\u0002Z\u001d9\u0011QM\u000e\t\u0002\u0005\u001ddA\u0002\u000e\u001c\u0011\u0003\tI\u0007\u0003\u0004Q-\u0011\u0005\u00111\u0013\u0005\b\u0003+3B\u0011IAL\u0011%\tiJFA\u0001\n\u0013\tyJA\u000eXK&<\u0007\u000e^3e#V\fg\u000e^5mK\u0012K7o\u0019:fi&TXM\u001d\u0006\u00039u\tqAZ3biV\u0014XM\u0003\u0002\u001f?\u0005\u0011Q\u000e\u001c\u0006\u0003A\u0005\nQa\u001d9be.T!AI\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0013aA8sO\u000e\u00011#\u0002\u0001(_IR\u0004c\u0001\u0015*W5\tQ$\u0003\u0002+;\tIQi\u001d;j[\u0006$xN\u001d\t\u0003Y5j\u0011aG\u0005\u0003]m\u0011!BQ;dW\u0016$\u0018N_3s!\ta\u0003'\u0003\u000227\t9\u0012+^1oi&dW\rR5tGJ,G/\u001b>fe\n\u000b7/\u001a\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\naa\u001d5be\u0016$'BA\u001c\u001e\u0003\u0015\u0001\u0018M]1n\u0013\tIDG\u0001\u0007ICN<V-[4ii\u000e{G\u000e\u0005\u0002<}5\tAH\u0003\u0002>;\u0005!Q\u000f^5m\u0013\tyDHA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn],sSR\f'\r\\3\u0002\u0007ULG-F\u0001C!\t\u0019EJ\u0004\u0002E\u0015B\u0011Q\tS\u0007\u0002\r*\u0011q)J\u0001\u0007yI|w\u000e\u001e \u000b\u0003%\u000bQa]2bY\u0006L!a\u0013%\u0002\rA\u0013X\rZ3g\u0013\tieJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0017\"\u000bA!^5eA\u00051A(\u001b8jiz\"\"AU*\u0011\u00051\u0002\u0001\"\u0002!\u0004\u0001\u0004\u0011E#\u0001*\u0002\u001bI,G.\u0019;jm\u0016,%O]8s+\u00059\u0006C\u0001-Z\u001b\u00051\u0014B\u0001.7\u0005-!u.\u001e2mKB\u000b'/Y7\u0002\u001dI,G.\u0019;jm\u0016,%O]8sA\u0005\u0001r-\u001a;SK2\fG/\u001b<f\u000bJ\u0014xN]\u000b\u0002=B\u0011q\fY\u0007\u0002\u0011&\u0011\u0011\r\u0013\u0002\u0007\t>,(\r\\3\u0002!M,GOU3mCRLg/Z#se>\u0014HC\u00013f\u001b\u0005\u0001\u0001\"\u00024\t\u0001\u0004q\u0016!\u0002<bYV,\u0017!D:fi:+XNQ;dW\u0016$8\u000f\u0006\u0002eS\")a-\u0003a\u0001UB\u0011ql[\u0005\u0003Y\"\u00131!\u00138u\u0003-\u0019X\r^%oaV$8i\u001c7\u0015\u0005\u0011|\u0007\"\u00024\u000b\u0001\u0004\u0011\u0015\u0001D:fi>+H\u000f];u\u0007>dGC\u00013s\u0011\u001517\u00021\u0001C\u00031\u0019X\r^,fS\u001eDGoQ8m)\t!W\u000fC\u0003g\u0019\u0001\u0007!)\u0001\ttKRD\u0015M\u001c3mK&sg/\u00197jIR\u0011A\r\u001f\u0005\u0006M6\u0001\rAQ\u0001\u0013g\u0016$h*^7Ck\u000e\\W\r^:BeJ\f\u0017\u0010\u0006\u0002ew\")aM\u0004a\u0001yB\u0019q, 6\n\u0005yD%!B!se\u0006L\u0018\u0001D:fi&s\u0007/\u001e;D_2\u001cHc\u00013\u0002\u0004!1am\u0004a\u0001\u0003\u000b\u00012aX?C\u00035\u0019X\r^(viB,HoQ8mgR\u0019A-a\u0003\t\r\u0019\u0004\u0002\u0019AA\u0003\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\t\u0003C\u0001B!a\u0005\u0002\u001e5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0003usB,7OC\u0002\u0002\u001c}\t1a]9m\u0013\u0011\ty\"!\u0006\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002$E\u0001\r!!\u0005\u0002\rM\u001c\u0007.Z7b\u0003\r1\u0017\u000e\u001e\u000b\u0004W\u0005%\u0002bBA\u0016%\u0001\u0007\u0011QF\u0001\bI\u0006$\u0018m]3ua\u0011\ty#a\u000f\u0011\r\u0005E\u00121GA\u001c\u001b\t\tI\"\u0003\u0003\u00026\u0005e!a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003s\tY\u0004\u0004\u0001\u0005\u0019\u0005u\u0012\u0011FA\u0001\u0002\u0003\u0015\t!a\u0010\u0003\u0007}#\u0013'\u0005\u0003\u0002B\u0005\u001d\u0003cA0\u0002D%\u0019\u0011Q\t%\u0003\u000f9{G\u000f[5oOB\u0019q,!\u0013\n\u0007\u0005-\u0003JA\u0002B]f\f\u0011cZ3u\t&\u001cH/\u001b8diN\u0003H.\u001b;t)\u0011\t\t&a\u0015\u0011\u0007}kh\fC\u0004\u0002VM\u0001\r!!\u0015\u0002\rM\u0004H.\u001b;t\u0003\u0011\u0019w\u000e]=\u0015\u0007I\u000bY\u0006C\u0004\u0002^Q\u0001\r!a\u0018\u0002\u000b\u0015DHO]1\u0011\u0007a\u000b\t'C\u0002\u0002dY\u0012\u0001\u0002U1sC6l\u0015\r]\u0001\u001c/\u0016Lw\r\u001b;fIF+\u0018M\u001c;jY\u0016$\u0015n]2sKRL'0\u001a:\u0011\u0005122#\u0003\f\u0002l\u0005E\u0014qOAB!\ry\u0016QN\u0005\u0004\u0003_B%AB!osJ+g\r\u0005\u0003<\u0003g\u0012\u0016bAA;y\t)B)\u001a4bk2$\b+\u0019:b[N\u0014V-\u00193bE2,\u0007\u0003BA=\u0003\u007fj!!a\u001f\u000b\u0007\u0005ut$\u0001\u0005j]R,'O\\1m\u0013\u0011\t\t)a\u001f\u0003\u000f1{wmZ5oOB!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015AA5p\u0015\t\ti)\u0001\u0003kCZ\f\u0017\u0002BAI\u0003\u000f\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u001a\u0002\t1|\u0017\r\u001a\u000b\u0004%\u0006e\u0005BBAN1\u0001\u0007!)\u0001\u0003qCRD\u0017\u0001D<sSR,'+\u001a9mC\u000e,GCAAQ!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&\u0002BAT\u0003\u0017\u000bA\u0001\\1oO&!\u00111VAS\u0005\u0019y%M[3di\u0002")
public final class WeightedQuantileDiscretizer
extends Estimator<Bucketizer>
implements QuantileDiscretizerBase,
HasWeightCol,
DefaultParamsWritable {
    private final String uid;
    private final DoubleParam relativeError;
    private Param<String> weightCol;
    private IntParam numBuckets;
    private IntArrayParam numBucketsArray;
    private Param<String> handleInvalid;
    private StringArrayParam outputCols;
    private StringArrayParam inputCols;
    private Param<String> outputCol;
    private Param<String> inputCol;

    public static WeightedQuantileDiscretizer load(String path) {
        return (WeightedQuantileDiscretizer)MLReadable.load$((MLReadable)WeightedQuantileDiscretizer$.MODULE$, (String)path);
    }

    public static MLReader<WeightedQuantileDiscretizer> read() {
        return DefaultParamsReadable.read$((DefaultParamsReadable)WeightedQuantileDiscretizer$.MODULE$);
    }

    public MLWriter write() {
        return DefaultParamsWritable.write$((DefaultParamsWritable)this);
    }

    public void save(String path) throws IOException {
        MLWritable.save$((MLWritable)this, (String)path);
    }

    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$((HasWeightCol)this);
    }

    @Override
    public int getNumBuckets() {
        return QuantileDiscretizerBase.getNumBuckets$(this);
    }

    @Override
    public int[] getNumBucketsArray() {
        return QuantileDiscretizerBase.getNumBucketsArray$(this);
    }

    public final String[] getOutputCols() {
        return HasOutputCols.getOutputCols$((HasOutputCols)this);
    }

    public final String[] getInputCols() {
        return HasInputCols.getInputCols$((HasInputCols)this);
    }

    public final String getOutputCol() {
        return HasOutputCol.getOutputCol$((HasOutputCol)this);
    }

    public final String getInputCol() {
        return HasInputCol.getInputCol$((HasInputCol)this);
    }

    public final String getHandleInvalid() {
        return HasHandleInvalid.getHandleInvalid$((HasHandleInvalid)this);
    }

    public final Param<String> weightCol() {
        return this.weightCol;
    }

    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public IntParam numBuckets() {
        return this.numBuckets;
    }

    @Override
    public IntArrayParam numBucketsArray() {
        return this.numBucketsArray;
    }

    @Override
    public Param<String> handleInvalid() {
        return this.handleInvalid;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$numBuckets_$eq(IntParam x$1) {
        this.numBuckets = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$numBucketsArray_$eq(IntArrayParam x$1) {
        this.numBucketsArray = x$1;
    }

    @Override
    public void org$apache$spark$ml$feature$QuantileDiscretizerBase$_setter_$handleInvalid_$eq(Param<String> x$1) {
        this.handleInvalid = x$1;
    }

    public final StringArrayParam outputCols() {
        return this.outputCols;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCols$_setter_$outputCols_$eq(StringArrayParam x$1) {
        this.outputCols = x$1;
    }

    public final StringArrayParam inputCols() {
        return this.inputCols;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCols$_setter_$inputCols_$eq(StringArrayParam x$1) {
        this.inputCols = x$1;
    }

    public final Param<String> outputCol() {
        return this.outputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param<String> x$1) {
        this.outputCol = x$1;
    }

    public final Param<String> inputCol() {
        return this.inputCol;
    }

    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param<String> x$1) {
        this.inputCol = x$1;
    }

    public void org$apache$spark$ml$param$shared$HasHandleInvalid$_setter_$handleInvalid_$eq(Param<String> x$1) {
    }

    public String uid() {
        return this.uid;
    }

    public final DoubleParam relativeError() {
        return this.relativeError;
    }

    public final double getRelativeError() {
        DoubleParam $_param = this.relativeError();
        Object var1_1 = null;
        return BoxesRunTime.unboxToDouble((Object)Params.$$((Params)this, (Param)$_param));
    }

    /*
     * WARNING - void declaration
     */
    public WeightedQuantileDiscretizer setRelativeError(double value) {
        void set_value;
        Double d = new Double(value);
        DoubleParam set_param = this.relativeError();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, (Param)set_param, (Object)set_value);
    }

    public WeightedQuantileDiscretizer setNumBuckets(int value) {
        Integer set_value = value;
        IntParam set_param = this.numBuckets();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, (Param)set_param, (Object)set_value);
    }

    public WeightedQuantileDiscretizer setInputCol(String value) {
        Param<String> set_param = this.inputCol();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, set_param, (Object)value);
    }

    public WeightedQuantileDiscretizer setOutputCol(String value) {
        Param<String> set_param = this.outputCol();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, set_param, (Object)value);
    }

    public WeightedQuantileDiscretizer setWeightCol(String value) {
        Param<String> set_param = this.weightCol();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, set_param, (Object)value);
    }

    public WeightedQuantileDiscretizer setHandleInvalid(String value) {
        Param<String> set_param = this.handleInvalid();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, set_param, (Object)value);
    }

    public WeightedQuantileDiscretizer setNumBucketsArray(int[] value) {
        IntArrayParam set_param = this.numBucketsArray();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, (Param)set_param, (Object)value);
    }

    public WeightedQuantileDiscretizer setInputCols(String[] value) {
        StringArrayParam set_param = this.inputCols();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, (Param)set_param, (Object)value);
    }

    public WeightedQuantileDiscretizer setOutputCols(String[] value) {
        StringArrayParam set_param = this.outputCols();
        return (WeightedQuantileDiscretizer)Params.set$((Params)this, (Param)set_param, (Object)value);
    }

    public StructType transformSchema(StructType schema) {
        .colon.colon colon2;
        .colon.colon colon3;
        ParamValidators$.MODULE$.checkSingleVsMultiColumnParams((Params)this, (Seq)new .colon.colon(this.outputCol(), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)this.outputCols(), (List)Nil$.MODULE$));
        Param<String> isSet_param = this.inputCol();
        Object var5_2 = null;
        if (Params.isSet$((Params)this, isSet_param)) {
            IntArrayParam isSet_param2 = this.numBucketsArray();
            Object var6_3 = null;
            if (!(!Params.isSet$((Params)this, (Param)isSet_param2))) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"numBucketsArray can't be set for single-column WeightedQuantileDiscretizer.").toString());
            }
        }
        StringArrayParam isSet_param3 = this.inputCols();
        Object var7_4 = null;
        if (Params.isSet$((Params)this, (Param)isSet_param3)) {
            if (!(HasInputCols.getInputCols$((HasInputCols)this).length == HasOutputCols.getOutputCols$((HasOutputCols)this).length)) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)WeightedQuantileDiscretizer.$anonfun$transformSchema$2(this)).toString());
            }
            IntArrayParam isSet_param4 = this.numBucketsArray();
            Object var8_5 = null;
            if (Params.isSet$((Params)this, (Param)isSet_param4)) {
                if (!(HasInputCols.getInputCols$((HasInputCols)this).length == QuantileDiscretizerBase.getNumBucketsArray$(this).length)) {
                    throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)WeightedQuantileDiscretizer.$anonfun$transformSchema$3(this)).toString());
                }
                IntParam isSet_param5 = this.numBuckets();
                Object var9_6 = null;
                if (!(!Params.isSet$((Params)this, (Param)isSet_param5))) {
                    throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)"exactly one of numBuckets, numBucketsArray Params to be set, but both are set.").toString());
                }
            }
        }
        StringArrayParam isSet_param6 = this.inputCols();
        Object var10_7 = null;
        if (Params.isSet$((Params)this, (Param)isSet_param6)) {
            StringArrayParam $_param = this.inputCols();
            Object var11_8 = null;
            colon3 = ArrayOps$.MODULE$.toIndexedSeq$extension((Object)((Object[])Params.$$((Params)this, (Param)$_param)));
            StringArrayParam $_param2 = this.outputCols();
            Object var12_9 = null;
            colon2 = ArrayOps$.MODULE$.toIndexedSeq$extension((Object)((Object[])Params.$$((Params)this, (Param)$_param2)));
        } else {
            Param<String> $_param = this.inputCol();
            Object var13_10 = null;
            .colon.colon colon4 = new .colon.colon((Object)((String)Params.$$((Params)this, $_param)), (List)Nil$.MODULE$);
            colon3 = colon4;
            Param<String> $_param3 = this.outputCol();
            Object var14_11 = null;
            .colon.colon colon5 = new .colon.colon((Object)((String)Params.$$((Params)this, $_param3)), (List)Nil$.MODULE$);
            colon2 = colon5;
        }
        .colon.colon colon6 = colon2;
        Seq inputColNames = (Seq)colon3;
        Seq outputColNames = (Seq)colon6;
        StructField[] create_e = schema.fields();
        Object var15_15 = null;
        ObjectRef outputFields = new ObjectRef((Object)create_e);
        ((IterableOnceOps)inputColNames.zip((IterableOnce)outputColNames)).foreach((Function1 & Serializable)x0$1 -> {
            WeightedQuantileDiscretizer.$anonfun$transformSchema$5(schema, outputFields, x0$1);
            return BoxedUnit.UNIT;
        });
        return new StructType((StructField[])outputFields.elem);
    }

    /*
     * WARNING - void declaration
     */
    public Bucketizer fit(Dataset<?> dataset) {
        void copyValues_extra;
        this.transformSchema(dataset.schema(), true);
        Param<String> $_param = this.handleInvalid();
        Object var10_2 = null;
        Bucketizer bucketizer = new Bucketizer(this.uid()).setHandleInvalid((String)Params.$$((Params)this, $_param));
        StringArrayParam isSet_param = this.inputCols();
        Object var11_4 = null;
        if (Params.isSet$((Params)this, (Param)isSet_param)) {
            double[][] dArray;
            IntArrayParam isSet_param2 = this.numBucketsArray();
            Object var12_5 = null;
            if (Params.isSet$((Params)this, (Param)isSet_param2)) {
                void map$extension_ct;
                Object var40_21;
                double[] dArray2;
                int flatten$extension_i;
                Object object;
                void map$extension_ct2;
                IntArrayParam $_param2 = this.numBucketsArray();
                Object var13_6 = null;
                ClassTag classTag = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE));
                int[] map$extension_$this = (int[])Params.$$((Params)this, (Param)$_param2);
                int map$extension_len = map$extension_$this.length;
                Object map$extension_ys = map$extension_ct2.newArray(map$extension_len);
                if (map$extension_len > 0) {
                    for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                        ScalaRunTime$.MODULE$.array_update(map$extension_ys, map$extension_i, (Object)WeightedQuantileDiscretizer.$anonfun$fit$1(map$extension_$this[map$extension_i]));
                    }
                }
                Object var27_8 = null;
                classTag = null;
                Object var30_10 = null;
                double[][] probArrayPerCol = (double[][])map$extension_ys;
                ManifestFactory.DoubleManifest flatten$extension_m = ClassTag$.MODULE$.Double();
                Class clazz = flatten$extension_m.runtimeClass();
                Class<Byte> clazz2 = Byte.TYPE;
                if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofByte();
                } else {
                    Class<Short> clazz3 = Short.TYPE;
                    if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofShort();
                    } else {
                        Class<Character> clazz4 = Character.TYPE;
                        if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofChar();
                        } else {
                            Class<Integer> clazz5 = Integer.TYPE;
                            if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofInt();
                            } else {
                                Class<Long> clazz6 = Long.TYPE;
                                if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofLong();
                                } else {
                                    Class<Float> clazz7 = Float.TYPE;
                                    if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofFloat();
                                    } else {
                                        Class<Double> clazz8 = Double.TYPE;
                                        if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                            object = new ArrayBuilder.ofDouble();
                                        } else {
                                            Class<Boolean> clazz9 = Boolean.TYPE;
                                            if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                                object = new ArrayBuilder.ofBoolean();
                                            } else {
                                                Class<Void> clazz10 = Void.TYPE;
                                                object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef((ClassTag)flatten$extension_m);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                clazz = null;
                ArrayBuilder.ofByte flatten$extension_b = object;
                int flatten$extension_len = probArrayPerCol.length;
                int flatten$extension_size = 0;
                for (flatten$extension_i = 0; flatten$extension_i < flatten$extension_len; ++flatten$extension_i) {
                    dArray2 = probArrayPerCol[flatten$extension_i];
                    if (dArray2 instanceof IterableOnce) {
                        int flatten$extension_k = ((IterableOnce)dArray2).knownSize();
                        if (flatten$extension_k <= 0) continue;
                        flatten$extension_size += flatten$extension_k;
                        continue;
                    }
                    if (!ScalaRunTime$.MODULE$.isArray((Object)dArray2, 1)) continue;
                    flatten$extension_size += Array.getLength(dArray2);
                }
                if (flatten$extension_size > 0) {
                    flatten$extension_b.sizeHint(flatten$extension_size);
                }
                for (flatten$extension_i = 0; flatten$extension_i < flatten$extension_len; ++flatten$extension_i) {
                    double[] dArray3 = probArrayPerCol[flatten$extension_i];
                    ArraySeq.ofDouble flatten$extension_$plus$plus$eq_elems = Predef$.MODULE$.wrapDoubleArray(dArray3);
                    flatten$extension_b.addAll((IterableOnce)flatten$extension_$plus$plus$eq_elems);
                    var40_21 = null;
                }
                Object var32_13 = null;
                Object var33_15 = null;
                dArray2 = null;
                var40_21 = null;
                double[] probabilityArray = (double[])ArrayOps$.MODULE$.distinct$extension((Object)((double[])ArrayOps$.MODULE$.sorted$extension((Object)((double[])flatten$extension_b.result()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
                StringArrayParam $_param3 = this.inputCols();
                Object var14_24 = null;
                Param<String> $_param4 = this.weightCol();
                Object var15_25 = null;
                DoubleParam $_param5 = this.relativeError();
                Object var16_26 = null;
                double[][] splitsArrayRaw = WeightedQuantileSummaries$.MODULE$.approxWeightedQuantile((Dataset<Row>)dataset.toDF(), (String[])Params.$$((Params)this, (Param)$_param3), (String)Params.$$((Params)this, $_param4), probabilityArray, BoxesRunTime.unboxToDouble((Object)Params.$$((Params)this, (Param)$_param5)));
                ClassTag classTag2 = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE));
                Tuple2[] map$extension_$this2 = ArrayOps$.MODULE$.zip$extension((Object)splitsArrayRaw, (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])probArrayPerCol));
                int map$extension_len2 = map$extension_$this2.length;
                Object map$extension_ys2 = map$extension_ct.newArray(map$extension_len2);
                if (map$extension_len2 > 0) {
                    for (int map$extension_i = 0; map$extension_i < map$extension_len2; ++map$extension_i) {
                        Tuple2 tuple2 = map$extension_$this2[map$extension_i];
                        ScalaRunTime$.MODULE$.array_update(map$extension_ys2, map$extension_i, (Object)WeightedQuantileDiscretizer.$anonfun$fit$4(probabilityArray, tuple2));
                    }
                }
                Object var41_29 = null;
                classTag2 = null;
                Object var44_31 = null;
                dArray = (double[][])map$extension_ys2;
            } else {
                Double d;
                Dataset dataset2 = dataset.toDF();
                StringArrayParam $_param6 = this.inputCols();
                Object var17_34 = null;
                String[] stringArray = (String[])Params.$$((Params)this, (Param)$_param6);
                Param<String> $_param7 = this.weightCol();
                Object var18_35 = null;
                String string = (String)Params.$$((Params)this, $_param7);
                int n = 0;
                IntParam $_param8 = this.numBuckets();
                Object var19_37 = null;
                int to$extension_end = BoxesRunTime.unboxToInt((Object)Params.$$((Params)this, (Param)$_param8));
                Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
                map_this.scala$collection$immutable$Range$$validateMaxLength();
                Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
                Iterator map_strictOptimizedMap_it = map_this.iterator();
                while (map_strictOptimizedMap_it.hasNext()) {
                    void map_strictOptimizedMap_$plus$eq_elem;
                    int n2 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
                    d = BoxesRunTime.boxToDouble((double)WeightedQuantileDiscretizer.$anonfun$fit$5(this, n2));
                    if (map_strictOptimizedMap_b == null) {
                        throw null;
                    }
                    map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                    d = null;
                }
                Object var46_39 = null;
                Object var47_40 = null;
                Object var48_41 = null;
                d = null;
                DoubleParam $_param9 = this.relativeError();
                Object var20_44 = null;
                dArray = WeightedQuantileSummaries$.MODULE$.approxWeightedQuantile((Dataset<Row>)dataset2, stringArray, string, (double[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray((ClassTag)ClassTag$.MODULE$.Double()), BoxesRunTime.unboxToDouble((Object)Params.$$((Params)this, (Param)$_param9)));
            }
            double[][] splitsArray = dArray;
            ClassTag map$extension_ct = ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE));
            int map$extension_len = splitsArray.length;
            Object map$extension_ys = map$extension_ct.newArray(map$extension_len);
            if (map$extension_len > 0) {
                for (int map$extension_i = 0; map$extension_i < map$extension_len; ++map$extension_i) {
                    double[] dArray4 = splitsArray[map$extension_i];
                    ScalaRunTime$.MODULE$.array_update(map$extension_ys, map$extension_i, (Object)this.getDistinctSplits(dArray4));
                }
            }
            Object var50_46 = null;
            Object var52_48 = null;
            bucketizer.setSplitsArray((double[][])map$extension_ys);
        } else {
            Double d;
            Dataset dataset3 = dataset.toDF();
            String[] stringArray = new String[1];
            Param<String> $_param10 = this.inputCol();
            Object var21_51 = null;
            stringArray[0] = (String)Params.$$((Params)this, $_param10);
            Param<String> $_param11 = this.weightCol();
            Object var22_52 = null;
            String string = (String)Params.$$((Params)this, $_param11);
            int n = 0;
            IntParam $_param12 = this.numBuckets();
            Object var23_54 = null;
            int to$extension_end = BoxesRunTime.unboxToInt((Object)Params.$$((Params)this, (Param)$_param12));
            Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            Iterator map_strictOptimizedMap_it = map_this.iterator();
            while (map_strictOptimizedMap_it.hasNext()) {
                void map_strictOptimizedMap_$plus$eq_elem;
                int n3 = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
                d = BoxesRunTime.boxToDouble((double)WeightedQuantileDiscretizer.$anonfun$fit$7(this, n3));
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                d = null;
            }
            Object var54_56 = null;
            Object var55_57 = null;
            Object var56_58 = null;
            d = null;
            DoubleParam $_param13 = this.relativeError();
            Object var24_61 = null;
            double[][] splits = WeightedQuantileSummaries$.MODULE$.approxWeightedQuantile((Dataset<Row>)dataset3, stringArray, string, (double[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray((ClassTag)ClassTag$.MODULE$.Double()), BoxesRunTime.unboxToDouble((Object)Params.$$((Params)this, (Param)$_param13)));
            bucketizer.setSplits(this.getDistinctSplits(splits[0]));
        }
        ParamMap paramMap = Params.copyValues$default$2$((Params)this);
        Model copyValues_to = bucketizer.setParent((Estimator)this);
        return (Bucketizer)Params.copyValues$((Params)this, (Params)copyValues_to, (ParamMap)copyValues_extra);
    }

    private double[] getDistinctSplits(double[] splits) {
        splits[0] = Double.NEGATIVE_INFINITY;
        splits[splits.length - 1] = Double.POSITIVE_INFINITY;
        int n = 0;
        int until$extension_end = splits.length;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                WeightedQuantileDiscretizer.$anonfun$getDistinctSplits$1(splits, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var4_4 = null;
        double[] distinctSplits = (double[])ArrayOps$.MODULE$.distinct$extension((Object)splits);
        if (splits.length != distinctSplits.length) {
            Logging.log$((Logging)this).warn(new StringBuilder(65).append("Some quantiles were identical. Bucketing to ").append(distinctSplits.length - 1).append(" buckets as a result.").toString());
        }
        return (double[])ArrayOps$.MODULE$.sorted$extension((Object)distinctSplits, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
    }

    public WeightedQuantileDiscretizer copy(ParamMap extra) {
        return (WeightedQuantileDiscretizer)Params.defaultCopy$((Params)this, (ParamMap)extra);
    }

    public static final /* synthetic */ String $anonfun$transformSchema$1() {
        return "numBucketsArray can't be set for single-column WeightedQuantileDiscretizer.";
    }

    public static final /* synthetic */ String $anonfun$transformSchema$2(WeightedQuantileDiscretizer $this) {
        return new StringBuilder(175).append("WeightedQuantileDiscretizer ").append($this).append(" has mismatched Params ").append("for multi-column transform. Params (inputCols, outputCols) should have ").append("equal lengths, but they have different lengths: ").append("(").append(HasInputCols.getInputCols$((HasInputCols)$this).length).append(", ").append(HasOutputCols.getOutputCols$((HasOutputCols)$this).length).append(").").toString();
    }

    public static final /* synthetic */ String $anonfun$transformSchema$3(WeightedQuantileDiscretizer $this) {
        return new StringBuilder(194).append("WeightedQuantileDiscretizer ").append($this).append(" has mismatched Params ").append("for multi-column transform. Params (inputCols, outputCols, numBucketsArray) ").append("should have equal lengths, but they have different lengths: ").append("(").append(HasInputCols.getInputCols$((HasInputCols)$this).length).append(", ").append(HasOutputCols.getOutputCols$((HasOutputCols)$this).length).append(", ").append(QuantileDiscretizerBase.getNumBucketsArray$($this).length).append(").").toString();
    }

    public static final /* synthetic */ String $anonfun$transformSchema$4() {
        return "exactly one of numBuckets, numBucketsArray Params to be set, but both are set.";
    }

    public static final /* synthetic */ String $anonfun$transformSchema$6(Tuple2 x1$1) {
        return new StringBuilder(30).append("Output column ").append(x1$1._2()).append(" already exists.").toString();
    }

    public static final /* synthetic */ void $anonfun$transformSchema$5(StructType schema$1, ObjectRef outputFields$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            SchemaUtils$.MODULE$.checkNumericType(schema$1, (String)x0$1._1(), "");
            if (!(!ArrayOps$.MODULE$.contains$extension((Object)schema$1.fieldNames(), x0$1._2()))) {
                throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append((Object)WeightedQuantileDiscretizer.$anonfun$transformSchema$6(x0$1)).toString());
            }
            NominalAttribute attr = NominalAttribute$.MODULE$.defaultAttr().withName((String)x0$1._2());
            outputFields$1.elem = (StructField[])ArrayOps$.MODULE$.appended$extension((Object)((StructField[])outputFields$1.elem), (Object)attr.toStructField(), ClassTag$.MODULE$.apply(StructField.class));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$fit$2(int numOfBuckets$1, int x$2) {
        return (double)x$2 / (double)numOfBuckets$1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$fit$1(int numOfBuckets) {
        Double d;
        int n = 0;
        Range.Inclusive map_this = new Range.Inclusive(n, numOfBuckets, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            double boxToDouble_d = (double)BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()) / (double)numOfBuckets;
            d = new Double(boxToDouble_d);
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            d = null;
        }
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        d = null;
        return (double[])((IndexedSeq)map_strictOptimizedMap_b.result()).toArray((ClassTag)ClassTag$.MODULE$.Double());
    }

    public static final /* synthetic */ ArraySeq.ofDouble $anonfun$fit$3(double[] xs) {
        return Predef$.MODULE$.wrapDoubleArray(xs);
    }

    public static final /* synthetic */ double[] $anonfun$fit$4(double[] probabilityArray$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            ArraySeq.ofDouble ofDouble2 = Predef$.MODULE$.wrapDoubleArray((double[])x0$1._2());
            if (ofDouble2 == null) {
                throw null;
            }
            ArraySeq.ofDouble toSet_this = ofDouble2;
            Object var4_2 = null;
            Set probSet = IterableOnceOps.toSet$((IterableOnceOps)toSet_this);
            ArraySeq.ofInt ofInt2 = Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.collect$extension((Object)ArrayOps$.MODULE$.zipWithIndex$extension((Object)probabilityArray$1), (PartialFunction)new Serializable(null, probSet){
                private static final long serialVersionUID = 0L;
                private final Set probSet$1;

                /*
                 * WARNING - void declaration
                 */
                public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    if (x1 != null) {
                        void apply_elem;
                        Set set = this.probSet$1;
                        double boxToDouble_d = x1._1$mcD$sp();
                        Double d = new Double(boxToDouble_d);
                        if (set == null) {
                            throw null;
                        }
                        d = null;
                        if (set.contains((Object)apply_elem)) {
                            return (B1)Integer.valueOf(x1._2$mcI$sp());
                        }
                    }
                    return (B1)function1.apply(x1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final boolean isDefinedAt(Tuple2<Object, Object> x1) {
                    if (x1 != null) {
                        void apply_elem;
                        Set set = this.probSet$1;
                        double boxToDouble_d = x1._1$mcD$sp();
                        Double d = new Double(boxToDouble_d);
                        if (set == null) {
                            throw null;
                        }
                        d = null;
                        if (set.contains((Object)apply_elem)) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.probSet$1 = probSet$1;
                }
            }, (ClassTag)ClassTag$.MODULE$.Int()));
            if (ofInt2 == null) {
                throw null;
            }
            ArraySeq.ofInt toSet_this2 = ofInt2;
            Object var5_4 = null;
            Set idxSet = IterableOnceOps.toSet$((IterableOnceOps)toSet_this2);
            return (double[])ArrayOps$.MODULE$.collect$extension((Object)ArrayOps$.MODULE$.zipWithIndex$extension((Object)((double[])x0$1._1())), (PartialFunction)new Serializable(null, idxSet){
                private static final long serialVersionUID = 0L;
                private final Set idxSet$1;

                /*
                 * WARNING - void declaration
                 */
                public final <A1 extends Tuple2<Object, Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    if (x2 != null) {
                        void apply_elem;
                        Set set = this.idxSet$1;
                        Integer n = x2._2$mcI$sp();
                        if (set == null) {
                            throw null;
                        }
                        n = null;
                        if (set.contains((Object)apply_elem)) {
                            double boxToDouble_d = x2._1$mcD$sp();
                            return (B1)new Double(boxToDouble_d);
                        }
                    }
                    return (B1)function1.apply(x2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final boolean isDefinedAt(Tuple2<Object, Object> x2) {
                    if (x2 != null) {
                        void apply_elem;
                        Set set = this.idxSet$1;
                        Integer n = x2._2$mcI$sp();
                        if (set == null) {
                            throw null;
                        }
                        n = null;
                        if (set.contains((Object)apply_elem)) {
                            return true;
                        }
                    }
                    return false;
                }
                {
                    this.idxSet$1 = idxSet$1;
                }
            }, (ClassTag)ClassTag$.MODULE$.Double());
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ double $anonfun$fit$5(WeightedQuantileDiscretizer $this, int x$3) {
        IntParam $_param = $this.numBuckets();
        Object var2_2 = null;
        return (double)x$3 / (double)BoxesRunTime.unboxToInt((Object)Params.$$((Params)$this, (Param)$_param));
    }

    public static final /* synthetic */ double $anonfun$fit$7(WeightedQuantileDiscretizer $this, int x$4) {
        IntParam $_param = $this.numBuckets();
        Object var2_2 = null;
        return (double)x$4 / (double)BoxesRunTime.unboxToInt((Object)Params.$$((Params)$this, (Param)$_param));
    }

    public static final /* synthetic */ void $anonfun$getDistinctSplits$1(double[] splits$1, int i) {
        if (splits$1[i] == -0.0) {
            splits$1[i] = 0.0;
            return;
        }
    }

    public WeightedQuantileDiscretizer(String uid) {
        this.uid = uid;
        HasHandleInvalid.$init$((HasHandleInvalid)this);
        HasInputCol.$init$((HasInputCol)this);
        HasOutputCol.$init$((HasOutputCol)this);
        HasInputCols.$init$((HasInputCols)this);
        HasOutputCols.$init$((HasOutputCols)this);
        QuantileDiscretizerBase.$init$(this);
        HasWeightCol.$init$((HasWeightCol)this);
        this.relativeError = new DoubleParam((Identifiable)this, "relativeError", "the relative target precision for the approximate quantile algorithm. Must be in the range [0, 1]", ParamValidators$.MODULE$.inRange(0.0, 1.0, true, true));
        double boxToDouble_d = 0.001;
        Double setDefault_value = new Double(boxToDouble_d);
        DoubleParam setDefault_param = this.relativeError();
        Params.setDefault$((Params)this, (Param)setDefault_param, (Object)setDefault_value);
        Object var2_4 = null;
        Object var3_3 = null;
        Statics.releaseFence();
    }

    public WeightedQuantileDiscretizer() {
        this(Identifiable$.MODULE$.randomUID("weightedQuantileDiscretizer"));
    }

    public static final /* synthetic */ double[] $anonfun$fit$1$adapted(Object numOfBuckets) {
        return WeightedQuantileDiscretizer.$anonfun$fit$1(BoxesRunTime.unboxToInt((Object)numOfBuckets));
    }
}

