% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_function.R
\name{optimization_function}
\alias{optimization_function}
\title{Optimization equation to select spatial predictors}
\usage{
optimization_function(
  x = NULL,
  weight.r.squared = NULL,
  weight.penalization.n.predictors = NULL,
  optimization.method = "moran.i"
)
}
\arguments{
\item{x}{Optimization data frame generated internally by \code{\link[=select_spatial_predictors_sequential]{select_spatial_predictors_sequential()}} or \code{\link[=select_spatial_predictors_recursive]{select_spatial_predictors_recursive()}}. Default: \code{NULL}}

\item{weight.r.squared}{Numeric between 0 and 1, weight of R-squared in the optimization process. Default: \code{NULL}}

\item{weight.penalization.n.predictors}{Numeric between 0 and 1, weight of the penalization on the number of added spatial predictors. Default: \code{NULL}}

\item{optimization.method}{Character, one of "moran.i", and "p.value". Default: \code{"moran.i"}}
}
\value{
A numeric vector with the optimization criteria.
}
\description{
Optimizes the selection of spatial predictors using two different methods: "moran.i", and "p.value".
}
\details{
The method "moran.i" tries to maximize \verb{1 - Moran's} I while taking into account the R-squared of the model and a penalization on the number of introduced spatial predictors through the expression

(1 - Moran's I) + w1 * r.squared - w2 * penalization

The method "p.value" uses a binary version of the p-values of Moran's I (1 if >= 0.05, 0 otherwise), and uses the expression

max(1 - Moran's I, binary p-value) + w1 * r.squared - w2 * penalization

The "moran.i" method generally selects more spatial predictors than the "p.value" method.
}
\seealso{
\code{\link[=select_spatial_predictors_recursive]{select_spatial_predictors_recursive()}}, \code{\link[=select_spatial_predictors_sequential]{select_spatial_predictors_sequential()}}
}
