% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/points_in_circle.R
\name{points_in_circle}
\alias{points_in_circle}
\title{Filter observations within circle}
\usage{
points_in_circle(
  data,
  lon_center,
  lat_center,
  lon = lon,
  lat = lat,
  radius = 200
)
}
\arguments{
\item{data}{data.frame with at least columns for longitude and latitude.}

\item{lon_center}{numeric. Representing the longitude of the circle's center.}

\item{lat_center}{numeric. Representing the latitude of the circle's center.}

\item{lon}{column name in \code{data} containing longitudes
(default is \code{lon}).}

\item{lat}{column name in \code{data} containing latitudes
(default is \code{lat}).}

\item{radius}{radius of the circle in meters (default is 200m).}
}
\value{
A subset of the input data.frame containing only the observations
that fall within the specified circle.
}
\description{
Filter all observations in a data.frame that fall within a
circle of a specified radius drawn around a given latitude and longitude
point.
}
\examples{
points_in_circle(Groningen, lon_center = 6.571561, lat_center = 53.21326,
radius = 60)

}
\author{
Martin Haringa
}
