% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{animate_gganimate}
\alias{animate_gganimate}
\title{Animate a ggtour as a .gif via \code{{gganimate}}}
\usage{
animate_gganimate(
  ggtour,
  fps = 8,
  rewind = FALSE,
  start_pause = 1,
  end_pause = 1,
  ...
)
}
\arguments{
\item{ggtour}{A grammar of graphics tour with appended protos added.
A return from \verb{ggtour() + proto_*()}.}

\item{fps}{Number of Frames Per Second, the speed resulting animation.}

\item{rewind}{Whether or not the animation should play backwards,
in reverse order once reaching the end. Defaults to FALSE.}

\item{start_pause}{The duration in seconds to wait before starting the
animation. Defaults to 1 second.}

\item{end_pause}{The duration in seconds to wait after ending the animation,
before it restarts from the first frame. Defaults to 1 second.}

\item{...}{Other arguments passed to
\code{\link[gganimate:animate]{gganimate::animate}}.}
}
\description{
Animates the ggplot return of \code{ggtour()} and added \verb{proto_*()} functions as a
.gif without interaction, through use of \code{{gganimate}}.
}
\examples{
library(spinifex)
dat     <- scale_sd(penguins_na.rm[, 1:4])
clas    <- penguins_na.rm$species
bas     <- basis_pca(dat)
mv      <- manip_var_of(bas)
mt_path <- manual_tour(bas, manip_var = mv)

ggt <- ggtour(mt_path, dat, angle = .3) +
  proto_default(aes_args = list(color = clas, shape = clas),
                identity_args = list(size = 1.5, alpha = .7))
\dontrun{
## Default .gif rendering
animate_gganimate(ggt)

if(FALSE){ ## Don't accidentally save file
  ## Option arguments, rendering to default .gif
  anim <- animate_gganimate(
    ggt, fps = 10, rewind = TRUE,
    start_pause = 1, end_pause = 2,
    height = 10, width = 15, units = "cm", ## "px", "in", "cm", or "mm."
    res = 200 ## resolution, pixels per dimension unit I think
  )
  ## Save rendered animation
  gganimate::anim_save("my_tour.gif",
                       animation = anim,
                       path = "./figures")
  
  ## Alternative renderer saving directly to .mp4
  animate_gganimate(ggt, fps = 5,
    height = 4, width = 6, units = "in", ## "px", "in", "cm", or "mm."
    res = 200, ## resolution, pixels per dimension unit I think
    renderer = gganimate::av_renderer("./my_tour.mp4"))
}
}
}
\seealso{
\code{\link[gganimate:animate]{gganimate::animate}}

Other ggtour animator: 
\code{\link{animate_plotly}()},
\code{\link{filmstrip}()}
}
\concept{ggtour animator}
