% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{plot_pca}
\alias{plot_pca}
\title{Plot 2 components of Principal Component Analysis}
\usage{
plot_pca(data, components = c(1, 2), ...)
}
\arguments{
\item{data}{Numeric matrix or data.frame of the observations.}

\item{components}{The 2 numbers of the principal components to use.}

\item{...}{Optionally pass arguments to \code{proto_default}}
}
\description{
Performs PCA on the data and used \code{proto_default} to plot with percent
variation labels.
}
\examples{
dat <- scale_sd(wine[, 2:6])
plot_pca(data = dat)

## Different components, class coloring
clas <- as.factor(wine$Type)
plot_pca(data = dat, components = c(1, 3), position = "center",
         aes_args = list(color = clas, shape = clas))
}
\seealso{
\code{\link[=proto_default]{proto_default()}}
}
