% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionsPlotting_moderate.R
\name{superbPlot.pointjitter}
\alias{superbPlot.pointjitter}
\title{superbPlot point-and-jitter dots layout}
\usage{
superbPlot.pointjitter(
  summarydata,
  xfactor,
  groupingfactor,
  addfactors,
  rawdata,
  pointParams = list(),
  jitterParams = list(),
  errorbarParams = list(),
  facetParams = list(),
  xAsFactor = TRUE
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xfactor}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfactor}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{pointParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{jitterParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_superberrorbar layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer}

\item{xAsFactor}{(optional) Boolean to indicate if the factor on the horizontal should continuous or discrete (default is discrete)}
}
\value{
a ggplot object
}
\description{
superbPlot comes with a few built-in templates for making the final plots.
All produces ggplot objects that can be further customized. Additionally, it is
possible to add custom-make templates (see vignette 6). The functions, to be
"superbPlot-compatible", must have these parameters:
}
\examples{
# This will make a plot with jittered points, aka dot plots
superb(
   len ~ dose + supp,
   ToothGrowth, 
   plotLayout="pointjitter" 
)

# if you extract the data with superbData, you can 
# run this layout directly
#processedData <- superb(
#   len ~ dose + supp,
#   ToothGrowth, 
#   showPlot = FALSE
#)
#
#superbPlot.pointjitter(processedData$summaryStatistic,
#   "dose",
#   "supp",
#   ".~.",
#   processedData$rawData)

}
