% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_intersection_sw.R
\name{test_zmax_onesided}
\alias{test_zmax_onesided}
\title{One-sided Zmax test}
\usage{
test_zmax_onesided(par, vcov, noninf = 0, index = NULL, par.name = "theta")
}
\arguments{
\item{par}{(numeric) parameter estimates or \code{estimate} object}

\item{vcov}{(matrix) asymptotic variance estimate}

\item{noninf}{(numeric) non-inferiority margins}

\item{index}{(integer) subset of parameters to test}

\item{par.name}{(character) parameter names in output}
}
\value{
\code{htest} object
}
\description{
Calculating test statistics and p-values for the
onesided Zmax / minP test.z

Given parameter estimates \eqn{(\widehat{\theta}_1, \ldots,
 \widehat{\theta}_p)^\top} with approximate assymptotic covariance matrix
\eqn{\widehat{S}}, let \eqn{ Z_i = \frac{\widehat{\theta}_i -
 \delta_i}{\operatorname{SE}(\widehat{\theta}_i)}} , where
\eqn{\operatorname{SE}(\widehat{\theta}_i) = \widehat{S}_{ii}}. The Zmax
test statistic is then \eqn{Z_{max} = \max \{Z_1,\ldots,Z_p\}}, and the
null-hypothesis is \eqn{H_0: \theta_i \leq \delta_i, i=1,\ldots,p} with
non-inferiority margin \eqn{\delta_i, i=1,\ldots,p}, for which the p-value
is calculated as \eqn{ 1 - \Phi_R(Z_{max}) } where \eqn{\phi_R} is the CDF
of the multivariate normal distribution with mean zero and correlation
matrix \eqn{R = \operatorname{diag}(S_{11}^{-0.5}, \ldots,
 S_{pp}^{-0.5})S\operatorname{diag}(S_{11}^{-0.5}, \ldots, S_{pp}^{-0.5})}.
}
\seealso{
\code{\link[=test_intersection_sw]{test_intersection_sw()}} \code{\link[lava:compare]{lava::test_wald()}}
\code{\link[lava:closed_testing]{lava::closed_testing()}}
}
\author{
Christian Bressen Pipper, Klaus Kähler Holst
}
