% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_km.R
\name{tm_g_km}
\alias{tm_g_km}
\title{teal Module: Kaplan-Meier Plot}
\usage{
tm_g_km(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  arm_ref_comp = NULL,
  paramcd,
  strata_var,
  facet_var,
  time_unit_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, "AVALU"),
    "AVALU", fixed = TRUE),
  aval_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVAL"), "AVAL", fixed = TRUE),
  cnsr_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "CNSR"), "CNSR", fixed = TRUE),
  conf_level = teal.transform::choices_selected(c(0.95, 0.9, 0.8), 0.95, keep_order =
    TRUE),
  conf_type = teal.transform::choices_selected(c("plain", "log", "log-log"), "plain",
    TRUE),
  font_size = c(11L, 1L, 30),
  control_annot_surv_med = tern::control_surv_med_annot(),
  control_annot_coxph = tern::control_coxph_annot(x = 0.27, y = 0.35, w = 0.3),
  legend_pos = c(0.9, 0.5),
  rel_height_plot = c(80L, 0L, 100L),
  plot_height = c(800L, 400L, 5000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable in the results table.}

\item{arm_ref_comp}{(\code{list}) optional,\cr if specified it must be a named list with each element corresponding to
an arm variable in \code{ADSL} and the element must be another list (possibly
with delayed \code{\link[teal.transform:variable_choices]{teal.transform::variable_choices()}} or delayed \code{\link[teal.transform:value_choices]{teal.transform::value_choices()}}
with the elements named \code{ref} and \code{comp} that the defined the default
reference and comparison arms when the arm variable is changed.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{strata_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr names of
the variables for stratified analysis.}

\item{facet_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for names of variable that can be used for plot faceting.}

\item{time_unit_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object
with all available choices and pre-selected option for the time unit variable.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{cnsr_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the censoring variable.}

\item{conf_level}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the confidence level, each within range of (0, 1).}

\item{conf_type}{(\code{string})\cr confidence interval type for median survival time CI. Options are "plain" (default),
"log", "log-log".}

\item{font_size}{(\code{numeric})\cr numeric vector of length 3 of current, minimum and maximum font size values.}

\item{control_annot_surv_med}{(\code{list})\cr parameters to control the position and size of the annotation table added
to the plot when \code{annot_surv_med = TRUE}, specified using the \code{\link[tern:control_surv_med_annot]{control_surv_med_annot()}} function. Parameter
options are: \code{x}, \code{y}, \code{w}, \code{h}, and \code{fill}. See \code{\link[tern:control_surv_med_annot]{control_surv_med_annot()}} for details.}

\item{control_annot_coxph}{(\code{list})\cr parameters to control the position and size of the annotation table added
to the plot when \code{annot_coxph = TRUE}, specified using the \code{\link[tern:control_coxph_annot]{control_coxph_annot()}} function. Parameter
options are: \code{x}, \code{y}, \code{w}, \code{h}, \code{fill}, and \code{ref_lbls}. See \code{\link[tern:control_coxph_annot]{control_coxph_annot()}} for details.}

\item{legend_pos}{(\code{numeric(2)} or \code{NULL})\cr vector containing x- and y-coordinates, respectively, for the legend
position relative to the KM plot area. If \code{NULL} (default), the legend is positioned in the bottom right corner of
the plot, or the middle right of the plot if needed to prevent overlapping.}

\item{rel_height_plot}{(\code{proportion})\cr proportion of total figure height to allocate to the Kaplan-Meier plot.
Relative height of patients at risk table is then \code{1 - rel_height_plot}. If \code{annot_at_risk = FALSE} or
\code{as_list = TRUE}, this parameter is ignored.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a \code{ggplot}-style Kaplan-Meier plot for data with ADaM structure.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_km(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(nestcolor)

data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl
  ADTTE <- tmc_ex_adtte
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADTTE <- data[["ADTTE"]]

arm_ref_comp <- list(
  ACTARMCD = list(
    ref = "ARM B",
    comp = c("ARM A", "ARM C")
  ),
  ARM = list(
    ref = "B: Placebo",
    comp = c("A: Drug X", "C: Combination")
  )
)

app <- init(
  data = data,
  modules = modules(
    tm_g_km(
      label = "Kaplan-Meier Plot",
      dataname = "ADTTE",
      arm_var = choices_selected(
        variable_choices(ADSL, c("ARM", "ARMCD", "ACTARMCD")),
        "ARM"
      ),
      paramcd = choices_selected(
        value_choices(ADTTE, "PARAMCD", "PARAM"),
        "OS"
      ),
      arm_ref_comp = arm_ref_comp,
      strata_var = choices_selected(
        variable_choices(ADSL, c("SEX", "BMRKR2")),
        "SEX"
      ),
      facet_var = choices_selected(
        variable_choices(ADSL, c("SEX", "BMRKR2")),
        NULL
      )
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo6AIIAIgDKADKROqQwBDFwAB4xUPyi1KUVlba2Tg1NLe2d-KTkSgC+QQBWRLkxANZwrKL5yTap-HDGUMKkMQT8tKIti8trG8DQ8JsFcgC6rhBVdQ0FwMAKYB+1P7PV7vAZDL7JH5-KqDFxgYFvFgwGKMfYnIgwVANOiiUjsPrlADCtnKWAAsoTKjoALw6HF4vplVHGGk6aHknQAIT+uEZOmImNZBHx-w55R5bNFZJ0hL+QTKcl5EDKpOltPp+OVZR0zNZf05iB0AAVqFACHB6EQeXyBVjacLoYbKoxBABzHQADQlf0JhsJGPouTClmCYHlOiCQSUaCxqVymU1ZQKrIKSrKfCEIlErIzwjEie1TRirtWMAL2rpUHocGoerAAGk0KaIAYyXBaKpjf5SNatRWCvddLToWC4WmKzokTFNCwhVklubRDFRDW4Oo4PxyxOZ4xaFWRCd5zJ8wCig6pd6pZTL0SSeTr2HFXyK+yyX9nxHxxXUCxYKc5wuYjLqu66bh+ZQztQghwIegGbDCQxFH8RqkuUFKVJeKFYGhcpfhOfwAPLVO+fbak+pFlFOzLooKtJUWitp4WUuLMOE06zvaR6LsBIigVuFY7nu9AHgQXEnjUtRniK1ROF6eCSpyZJYPWWAAExyuRE7an8MlyR+mkTgc5rHDuAHHkuK68eQYEUdqgn7jBolwewp78tJsmXopylqRpTHagAcg4tSArZ4YKn0kZKLQLLsLk5BqBo2jWDYJRaqIOQQKw5ToOwMYACSCLQRT5SujDaIEsxKGAMzPEAA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQSvxQpFD6RlzUAPqh4dYhYRGGOgDutKQAFrQQ7PFQuDogSjo6AIIAIgDKADKROqQwBDFwAB4xUPyi1KUVlba2Tg1NLe2d-KTkSgC+QQBWRLkxANZwrKL5yTap-HDGUMKkMQT8tKIti8trG8DQ8JsFcgC6rhBVdQ0FwMAKYB+1P7PV7vAZDL7JH5-KqDFxgYFvFgwGKMfYnIgwVANOiiUjsPrlADCtnKWAAsoTKjoALw6HF4vplVHGGk6aHknQAIT+uEZOmImNZBHx-w55R5bNFZJ0hL+QTKcl5EDKpOltPp+OVZR0zNZf05iB0AAVqFACHB6EQeXyBVjacLoYbKoxBABzHQADQlf0JhsJGPouTClmCYHlOiCQSUaCxqVymU1ZQKrIKSrKfCEIlErIzwjEie1TRirtWMAL2rpUHocGoerAAGk0KaIAYyXBaKpjf5SNatRWCvddLToWC4WmKzokTFNCwhVklubRDFRDW4Oo4PxyxOZ4xaFWRCd5zJ8wCig6pd6pZTL0SSeTr2HFXyK+yyX9nxHxxXUCxYKc5wuYjLqu66bh+ZQztQghwIegGbDCQxFH8RqkuUFKVJeKFYGhcpfhOfwAPLVO+fbak+pFlFOzLooKtJUWitp4WUuLMOE06zvaR6LsBIigVuFY7nu9AHgQXEnjUtRniK1ROF6eCSpyZJYPWWAAExyuRE7an8MlyR+mkTgc5rHDuAHHkuK68eQYEUdqgn7jBolwewp78tJsmXopylqRpTHagAcg4tSArZ4YKn0kZKLQLLsLk5BqBo2jWDYJRaqIOQQKw5ToOwMYACSCLQRT5SujDaIEsxKGAMzPEAA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

