% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attenuation.R
\name{attenuation}
\alias{attenuation}
\title{Calculate Attenuation from AUC and Other Transcript Features}
\usage{
attenuation(allaucdf, kneedf, matnatrans, bytranslistmean, expdf, dfmeandiff,
nbcpu = 1, significant = FALSE, replaceval = NA, pval = 0.1,
showtime = FALSE, verbose = TRUE)
}
\arguments{
\item{allaucdf}{A data frame containing AUC results for transcripts (see
allauc).}

\item{kneedf}{A data frame containing the inflection points (see kneeid).}

\item{matnatrans}{A data frame containing the number of missing values per
transcript (see countna).}

\item{bytranslistmean}{A list of data frames with mean values by transcripts.}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{dfmeandiff}{A data frame containing means and differences in mean
values, if more than one condition. (see meandifference).}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel processing. The parallelization is done on
bytranslistmean whose number of elements is equal to the
number of lines provided as input of 'averageandfilterexprs'.
Defaults to \code{1}.}

\item{significant}{A logical indicating whether to filter out non-significant
attenuation values. Defaults to \code{FALSE}.}

\item{replaceval}{A value to replace non-significant attenuation values
Defaults to \code{NA}.}

\item{pval}{A numeric value specifying the p-value threshold for significance
of the KS test. Defaults to \code{0.1}.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical value indicating whether to print progress messages
Defaults to \code{TRUE}.}
}
\value{
A data frame containing the computed attenuation values along with
        associated transcript information.
}
\description{
This function computes the attenuation values for each window of each
transcript based on the data frames obtained with the functions 'allauc',
'kneeid', and 'countna'.
}
\details{
The function merges several data frames to create a comprehensive
         dataset for each transcript. It computes mean values for the "up"
         and "down" segments of the transcript. The direction is determined
         by comparing the coordinates to the knee values. up = coord < knee
         and down = coord > knee. The up and down indexes are then retrieved
         and the attenuation scores are computed as:
             att <- 100 - downmean / upmean * 100
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Reading tables
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)

## Computing intermediate steps
avfilt <- averageandfilterexprs(expdf, transdf, expthres,
       showtime = FALSE, verbose = FALSE)
rescountna <- countna(avfilt, expdf, nbcpu = 1, verbose = FALSE)
ecdf <- genesECDF(avfilt, expdf, verbose = FALSE)
resecdf <- ecdf[[1]]
nbwindows <- ecdf[[2]]
resmeandiff <- meandifference(resecdf, expdf, nbwindows,
    verbose = FALSE)
bytranslistmean <- split(resmeandiff, factor(resmeandiff$transcript))
resknee <- kneeid(bytranslistmean, expdf, verbose = FALSE)
resauc <- allauc(bytranslistmean, expdf, nbwindows, verbose = FALSE)

## Testing attenuation
resatt <- attenuation(resauc, resknee, rescountna, bytranslistmean, expdf,
        resmeandiff, verbose = FALSE)

}
\seealso{
[allauc()], [kneeid()], [countna()], [meandifference()]
}
