% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{v_theme}
\alias{v_theme}
\title{Theme for Charts}
\usage{
v_theme(
  vc,
  .colorPalette = NULL,
  .backgroundColor = NULL,
  .borderColor = NULL,
  .shadowColor = NULL,
  .hoverBackgroundColor = NULL,
  .sliderRailColor = NULL,
  .sliderHandleColor = NULL,
  .sliderTrackColor = NULL,
  .popupBackgroundColor = NULL,
  .primaryFontColor = NULL,
  .secondaryFontColor = NULL,
  .tertiaryFontColor = NULL,
  .axisLabelFontColor = NULL,
  .disableFontColor = NULL,
  .axisMarkerFontColor = NULL,
  .axisGridColor = NULL,
  .axisDomainColor = NULL,
  .dataZoomHandleStrokeColor = NULL,
  .dataZoomChartColor = NULL,
  .playerControllerColor = NULL,
  .scrollBarSliderColor = NULL,
  .axisMarkerBackgroundColor = NULL,
  .markLabelBackgroundColor = NULL,
  .markLineStrokeColor = NULL,
  .dangerColor = NULL,
  .warningColor = NULL,
  .successColor = NULL,
  .infoColor = NULL,
  .discreteLegendPagerTextColor = NULL,
  .discreteLegendPagerHandlerColor = NULL,
  .discreteLegendPagerHandlerDisableColor = NULL,
  ...
)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{.colorPalette}{Vector of colors to use as default.}

\item{.backgroundColor}{background Color}

\item{.borderColor}{border Color}

\item{.shadowColor}{shadow Color}

\item{.hoverBackgroundColor}{hoverBackground Color}

\item{.sliderRailColor}{slider Rail Color}

\item{.sliderHandleColor}{slider Handle Color}

\item{.sliderTrackColor}{slider Track Color}

\item{.popupBackgroundColor}{popup Background Color}

\item{.primaryFontColor}{primary Font Color}

\item{.secondaryFontColor}{secondary Font Color}

\item{.tertiaryFontColor}{tertiary Font Color}

\item{.axisLabelFontColor}{axisLabel Font Color}

\item{.disableFontColor}{disable Font Color}

\item{.axisMarkerFontColor}{axis Marker Font Color}

\item{.axisGridColor}{axis Grid Color}

\item{.axisDomainColor}{axis Domain Color}

\item{.dataZoomHandleStrokeColor}{data Zoom Handle Stroke Color}

\item{.dataZoomChartColor}{data Zoom Chart Color}

\item{.playerControllerColor}{player Controller Color}

\item{.scrollBarSliderColor}{scroll Bar Slider Color}

\item{.axisMarkerBackgroundColor}{axis Marker Background Color}

\item{.markLabelBackgroundColor}{mark Label Background Color}

\item{.markLineStrokeColor}{mark Line Stroke Color}

\item{.dangerColor}{danger Color}

\item{.warningColor}{warning Color}

\item{.successColor}{success Color}

\item{.infoColor}{info Color}

\item{.discreteLegendPagerTextColor}{discrete Legend Pager Text Color}

\item{.discreteLegendPagerHandlerColor}{discrete Legend Pager Handler Color}

\item{.discreteLegendPagerHandlerDisableColor}{discrete Legend Pager Handler Disable Color}

\item{...}{Other parameters.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Theme for Charts
}
\examples{

library(vchartr)

chart <- subset(
  electricity_mix,
  country \%in\% c("Germany", "Brazil", "South Korea")
) \%>\%
  vchart() \%>\%
  v_bar(aes(country, generation, fill = source))

# Default appearance
chart

# Change background color
chart \%>\%
  v_theme(.backgroundColor = "#2F2E2F")

# Change default color palette
chart \%>\%
  v_theme(
    .colorPalette = palette.colors(n = 8, palette = "Okabe-Ito")[-1]
  )

# Axis grid color
chart \%>\%
  v_theme(.axisGridColor = "red")
# same as
chart \%>\%
  v_theme(
    component = list(
      axis = list(
        grid = list(
          style = list(
            # lineWidth = 3, # but more options available
            stroke = "red"
          )
        )
      )
    )
  )
# see https://www.unpkg.com/@visactor/vchart-theme@1.11.6/public/light.json
# for all possibilities
}
