% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{branches}
\alias{branches}
\alias{as.data.frame.vistla}
\title{Extract all branches of the Vistla tree}
\usage{
branches(x, suboptimal = FALSE)

\method{as.data.frame}{vistla}(x, row.names = NULL, optional = FALSE, suboptimal = FALSE, ...)
}
\arguments{
\item{x}{vistla object.}

\item{suboptimal}{if TRUE, sub-optimal branches are included.}

\item{row.names}{passed to \code{as.data.frame}.}

\item{optional}{passed to \code{as.data.frame}.}

\item{...}{ignored.}
}
\value{
A data frame collecting all branches traced by vistla.
 Each row corresponds to a single branch, i.e., edge between feature pairs.
 This way it is a triplet of original features, names of which are stored in \code{a},
 \code{b} and \code{c} columns.
 For instance, path \eqn{I \rightarrow J \rightarrow K \rightarrow L \rightarrow M} 
 would be stored in three rows, for \eqn{(a,b,c)}=\eqn{(I,J,K)}, \eqn{(J,K,L)}
 and \eqn{(K,L,M)}.
 The width of a path (minimal \eqn{\iota} value) between root and feature pair \eqn{(b,c)} is
 stored in the \code{score} column.
 \code{depth} stores the path depth, starting from 1 for pairs directly connected to the root,
 and increasing by one for each additional feature.
 Final column, \code{leaf}, is a logical path indicating whether the edge is a final segment
 of the widest path between root and \eqn{c}.
}
\description{
Gives access to a list of all branches in the tree.
}
\note{
Pruned trees (obtained with \code{\link{prune}} and using \code{targets} argument
 in the \code{\link{vistla}} call) have no suboptimal branches.
}
