% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rmwat}
\alias{rmwat}
\title{Random Sampling from a Mixture of Watson Distributions}
\usage{
rmwat(n, weights, kappa, mu, method = "acg", b = -10, rho = 1.1)
}
\arguments{
\item{n}{an integer giving the number of samples to draw.}

\item{weights}{a numeric vector with non-negative elements giving the mixture probabilities.}

\item{kappa}{a numeric vector giving the kappa parameters of the mixture components.}

\item{mu}{a numeric matrix with columns giving the mu parameters of the mixture components.}

\item{method}{a string indicating whether ACG sampler (\code{method = "acg"}), Tinflex sampler (\code{method = "tinflex"}) or automatic selection (\code{method = "auto"}) of the sampler should be used, default: "acg".}

\item{b}{a positive numeric hyper-parameter used in the sampling. If not a positive value is given, optimal choice of b is used, default: -10.}

\item{rho}{performance parameter: requested upper bound for ratio of area below hat to area below squeeze (numeric). See \code{\link[Tinflex]{Tinflex.setup}}, default: 1.1.}
}
\value{
A matrix with rows equal to the generated values.
}
\description{
\code{rmwat} generates a random sample from a mixture of multivariate Watson distributions.
}
\details{
The function generates samples from finite mixtures of Watson distributions,
         using methods from Sablica, Hornik and Leydold (2022) \url{https://www.tandfonline.com/doi/full/10.1080/10618600.2024.2416521}.
}
\examples{

## simulate from Watson distribution
sample1 <- rmwat(n = 20, weights = 1, kappa = 20, mu = matrix(c(1,1,1),nrow = 3))

## simulate from a mixture of Watson distributions
sample2 <- rmwat(n = 20, weights = c(0.5,0.5), kappa = c(-200,-200),
                            mu = matrix(c(1,1,1,-1,1,1),nrow = 3))
}
\references{
Sablica, Hornik and Leydold (2022). Random Sampling from the Watson Distribution \url{https://www.tandfonline.com/doi/full/10.1080/10618600.2024.2416521}.
}
