% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_lidar_remove_outliers}
\alias{wbt_lidar_remove_outliers}
\title{Lidar remove outliers}
\usage{
wbt_lidar_remove_outliers(
  input,
  output,
  radius = 2,
  elev_diff = 50,
  use_median = FALSE,
  classify = TRUE,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output LiDAR file.}

\item{radius}{Search Radius.}

\item{elev_diff}{Max. elevation difference.}

\item{use_median}{Optional flag indicating whether to use the difference from median elevation rather than mean.}

\item{classify}{Classify points as ground (2) or off-ground (1).}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Removes outliers (high and low points) in a LiDAR point cloud.
}
\keyword{LiDARTools}
