% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptance.R
\name{AcceptMetropolis}
\alias{AcceptMetropolis}
\title{Metropolis Acceptance Rule.}
\usage{
AcceptMetropolis(OperatorPipeline, gene, lF)
}
\arguments{
\item{OperatorPipeline}{Genetic operator pipeline.}

\item{gene}{Gene.}

\item{lF}{Local configuration.}
}
\value{
The new gene if it has at least equal performance as the 
        old gene else the old gene.
}
\description{
Change the gene by a genetic operator pipeline.
             Always accept a new gene with a fitness improvement.
             For maximizing fitness
             accept genes with lower fitness with probability
             \code{(runif(1)<exp(-(fitness-newfitness)*beta/Temperature)}
             and reduce temperature with a cooling schedule.
             Used: \code{Temperature<-alpha*Temperature} with 
             \code{alpha<1}.
}
\details{
The temperature is updated at the end of each generation
         in the main loop of the genetic algorithm.
}
\examples{
parm<-function(x){function() {return(x)}}
lFxegaGaGene$Beta<-parm(1)
lFxegaGaGene$TempK<-parm(10)
OPpipe1<-function(g, lF){InitGene(lF)}
g1<-lFxegaGaGene$EvalGene(InitGene(lFxegaGaGene), lFxegaGaGene)
g2<-AcceptMetropolis(OPpipe1, g1, lFxegaGaGene)
}
\references{
Kirkpatrick, S., Gelatt, C. D. J, and Vecchi, M. P. (1983):
     Optimization by Simulated Annealing. 
     Science, 220(4598): 671-680.
     <doi:10.1126/science.220.4598.671>

     Metropolis, N., Rosenbluth, A. W., Rosenbluth, M. N., Teller, A. H.,
     Teller, E. (1953):
     Equation of state calculations by fast computing machines.
     Journal of Chemical Physics, 21(6):1087 – 1092.
     <doi:10.1063/1.1699114>
}
\seealso{
Other Acceptance Rule: 
\code{\link{AcceptBest}()},
\code{\link{AcceptIVMetropolis}()},
\code{\link{AcceptNewGene}()}
}
\concept{Acceptance Rule}
