% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\docType{data}
\name{vars_mh_p_gbi}
\alias{vars_mh_p_gbi}
\alias{compute_mh_p_gbi_nm}
\title{Compute "Parent General Behavior Inventory [Parent]: Number missing"}
\format{
\code{vars_mh_p_gbi} is vector of all column names
used to compute summary score of \code{mh_p_gbi} scores.
}
\usage{
vars_mh_p_gbi

compute_mh_p_gbi_nm(data, name = "mh_p_gbi_nm", exclude = NULL, combine = TRUE)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_gbi_nm}
Parent General Behavior Inventory [Parent]: Number missing
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_gbi_001}
\item \code{mh_p_gbi_002}
\item \code{mh_p_gbi_003}
\item \code{mh_p_gbi_004}
\item \code{mh_p_gbi_005}
\item \code{mh_p_gbi_006}
\item \code{mh_p_gbi_007}
\item \code{mh_p_gbi_008}
\item \code{mh_p_gbi_009}
\item \code{mh_p_gbi_010}
}
\item \emph{Excluded values:} none
}
}
\examples{
\dontrun{
compute_mh_p_gbi_nm(data) |>
  select(
    any_of(c("mh_p_gbi_nm", vars_mh_p_gbi))
  )
}
}
\keyword{datasets}
