% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ps.R
\name{plot_ps}
\alias{plot_ps}
\title{Pollen Season Plot}
\usage{
plot_ps(
  data,
  pollen.type = NULL,
  year = NULL,
  days = 30,
  fill.col = "turquoise4",
  int.method = "lineal",
  axisname = expression(paste("Pollen grains / m"^"3")),
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} object including the general database where interpollation must be performed. This \code{data.frame} must include a first column in \code{Date} format and the rest of columns in \code{numeric} format. Each column must contain information of one pollen type. It is not necessary to insert missing gaps; the function will automatically detect them.}

\item{pollen.type}{A \code{character} string specifying the name of the pollen type which will be plotted. The name must be exactly the same that appears in the column name. Mandatory argument with no default.}

\item{year}{A \code{numeric (interger)} value specifying the season to be plotted. The season does not necessary fit a natural year. See \code{\link{calculate_ps}} for more details. Mandatory argument with no default.}

\item{days}{A \code{numeric (interger)} specifying the number of days beyond each side of the main pollen season that will be represented. The \code{days} argument will be \code{30} by default.}

\item{fill.col}{A \code{character} string specifying the name of the color to fill the main pollen season (Galan et al., 2017) in the plot. See \code{\link[ggplot2]{ggplot}} function for more details. The \code{fill.col} argument will be \code{"turquoise4"} by default.}

\item{int.method}{A \code{character} string specifying the method selected to apply the interpolation method in order to complete the pollen series. The implemented methods that may be used are: \code{"lineal"},  \code{"movingmean"}, \code{"spline"} or  \code{"tseries"}. See \code{\link{interpollen}} function for more details. The \code{int.method} argument will be \code{"lineal"} by default.}

\item{axisname}{A \code{character} string or an expression specifying the y axis title of the plot. The \code{axisname} argument will be \code{expression(paste("Pollen grains / m" ^ "3"))} by default.}

\item{...}{Other arguments passed on to the pollen season calculation as specified in \code{\link{calculate_ps}} function.}
}
\value{
The function returns an object of class \code{\link[ggplot2]{ggplot}} with a graphical representation of the main pollen season of the selected pollen type. The pre_peak and post_peak periods are marked with different color intensity.
}
\description{
Function to plot the main pollen season of a single pollen type.
}
\details{
\code{plot_ps} function is designed to easily plot the main pollen season (Galan et al., 2017). The pre_peak period and the post_peak period are marked with different color intensity in the graph. The user must choose a single pollen type and season to plot.
}
\examples{
data("munich_pollen")
plot_ps(munich_pollen, year = 2013, pollen.type = "Betula")
}
\references{
Galan, C., Ariatti, A., Bonini, M., Clot, B., Crouzy, B., Dahl, A., Fernandez_Gonzalez, D., Frenguelli, G., Gehrig, R., Isard, S., Levetin, E., Li, D.W., Mandrioli, P., Rogers, C.A., Thibaudon, M., Sauliene, I., Skjoth, C., Smith, M., Sofiev, M., 2017. Recommended terminology for aerobiological studies. Aerobiologia (Bologna). 293_295.
}
\seealso{
\code{\link{calculate_ps}}, \code{\link{interpollen}}, \code{\link[ggplot2]{ggplot}}.
}
