% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_ph.R
\docType{data}
\name{vars_ph_y_anthr__height}
\alias{vars_ph_y_anthr__height}
\alias{compute_ph_y_anthr__height_mean}
\title{Compute "Anthropometrics [Youth] (Height): Mean"}
\format{
vars_ph_y_anthr__height is a character vector of all column names
used to compute summary scores of \code{ph_y_anthr__height}.
}
\usage{
vars_ph_y_anthr__height

compute_ph_y_anthr__height_mean(
  data,
  name = "ph_y_anthr__height_mean",
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{ph_y_anthr__height_mean}
Anthropometrics [Youth] (Height): Mean
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{ph_y_anthr__height__r01_001}
\item \code{ph_y_anthr__height__r02_001}
\item \code{ph_y_anthr__height__r03_001}
}
\item \emph{Excluded values:} none
}
\subsection{Calculation}{

There are at most 3 possible measurements, and the calculation is as follows:
\itemize{
\item 0 missing, find the max and min of the three, and take the average of
the min and max. Then compare the average to the third value.
\itemize{
\item third value < average -> mean(min, third value)
\item third value > average -> mean(max, third value)
\item third value = average -> third value
}
\item 1 missing, mean of the rest two
\item 2 missing, use the last one
\item 3 missing, NA
}
}
}
\examples{
\dontrun{
compute_ph_y_anthr__height_mean(data) |>
  select(
    all_of(c("ph_y_anthr__height_mean", vars_ph_y_anthr__height))
  )
}
}
\keyword{datasets}
